/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.com.github.dockerjava.api.model;

import dev.monosoul.jooq.shadow.com.fasterxml.jackson.annotation.JsonCreator;
import dev.monosoul.jooq.shadow.com.fasterxml.jackson.annotation.JsonValue;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.DockerObject;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.ExposedPort;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.PortBinding;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Ports
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<ExposedPort, Binding[]> ports = new HashMap<ExposedPort, Binding[]>();

    public Ports() {
    }

    public Ports(ExposedPort exposedPort, Binding host) {
        this.bind(exposedPort, host);
    }

    public Ports(PortBinding ... portBindings) {
        this.add(portBindings);
    }

    public void bind(ExposedPort exposedPort, Binding binding) {
        if (this.ports.containsKey(exposedPort)) {
            Binding[] bindings = this.ports.get(exposedPort);
            Binding[] newBindings = new Binding[bindings.length + 1];
            System.arraycopy(bindings, 0, newBindings, 0, bindings.length);
            newBindings[newBindings.length - 1] = binding;
            this.ports.put(exposedPort, newBindings);
        } else if (binding == null) {
            this.ports.put(exposedPort, null);
        } else {
            this.ports.put(exposedPort, new Binding[]{binding});
        }
    }

    public void add(PortBinding ... portBindings) {
        for (PortBinding binding : portBindings) {
            this.bind(binding.getExposedPort(), binding.getBinding());
        }
    }

    public String toString() {
        return this.ports.toString();
    }

    public Map<ExposedPort, Binding[]> getBindings() {
        return this.ports;
    }

    @JsonCreator
    public static Ports fromPrimitive(Map<String, List<Map<String, String>>> map) {
        Ports out = new Ports();
        for (Map.Entry<String, List<Map<String, String>>> entry : map.entrySet()) {
            ExposedPort exposedPort = ExposedPort.parse(entry.getKey());
            if (entry.getValue() == null) {
                out.bind(exposedPort, null);
                continue;
            }
            for (Map<String, String> binding : entry.getValue()) {
                out.bind(exposedPort, new Binding(binding.get("HostIp"), binding.get("HostPort")));
            }
        }
        return out;
    }

    @JsonValue
    public Map<String, List<Map<String, String>>> toPrimitive() {
        return this.ports.entrySet().stream().collect(HashMap::new, (map, entry) -> {
            List value = entry.getValue() == null ? null : Stream.of((Object[])entry.getValue()).map(binding -> {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("HostIp", binding.getHostIp() == null ? "" : binding.getHostIp());
                result.put("HostPort", binding.getHostPortSpec() == null ? "" : binding.getHostPortSpec());
                return result;
            }).collect(Collectors.toList());
            map.put(((ExposedPort)entry.getKey()).toString(), value);
        }, HashMap::putAll);
    }

    public static class Binding
    extends DockerObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String hostIp;
        private final String hostPortSpec;

        public static Binding bindPortSpec(String portSpec) {
            return new Binding(null, portSpec);
        }

        public static Binding bindIp(String hostIp) {
            return new Binding(hostIp, null);
        }

        public static Binding bindIpAndPort(String hostIp, int port) {
            return new Binding(hostIp, "" + port);
        }

        public static Binding bindIpAndPortRange(String hostIp, int lowPort, int highPort) {
            return new Binding(hostIp, lowPort + "-" + highPort);
        }

        public static Binding bindPortRange(int lowPort, int highPort) {
            return Binding.bindIpAndPortRange(null, lowPort, highPort);
        }

        public static Binding bindPort(int port) {
            return Binding.bindIpAndPort(null, port);
        }

        public static Binding empty() {
            return new Binding(null, null);
        }

        public Binding(String hostIp, String hostPortSpec) {
            this.hostIp = hostIp == null || hostIp.length() == 0 ? null : hostIp;
            this.hostPortSpec = hostPortSpec;
        }

        public String getHostIp() {
            return this.hostIp;
        }

        public String getHostPortSpec() {
            return this.hostPortSpec;
        }

        public static Binding parse(String serialized) throws IllegalArgumentException {
            try {
                if (serialized.isEmpty()) {
                    return Binding.empty();
                }
                String[] parts = serialized.split(":");
                switch (parts.length) {
                    case 2: {
                        return new Binding(parts[0], parts[1]);
                    }
                    case 1: {
                        return parts[0].contains(".") ? Binding.bindIp(parts[0]) : Binding.bindPortSpec(parts[0]);
                    }
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error parsing Binding '" + serialized + "'");
            }
        }

        public String toString() {
            if (this.hostIp == null || this.hostIp.length() == 0) {
                return this.hostPortSpec;
            }
            if (this.hostPortSpec == null) {
                return this.hostIp;
            }
            return this.hostIp + ":" + this.hostPortSpec;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binding)) {
                return false;
            }
            Binding other = (Binding)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hostIp = this.getHostIp();
            String other$hostIp = other.getHostIp();
            if (this$hostIp == null ? other$hostIp != null : !this$hostIp.equals(other$hostIp)) {
                return false;
            }
            String this$hostPortSpec = this.getHostPortSpec();
            String other$hostPortSpec = other.getHostPortSpec();
            return !(this$hostPortSpec == null ? other$hostPortSpec != null : !this$hostPortSpec.equals(other$hostPortSpec));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Binding;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostIp = this.getHostIp();
            result = result * 59 + ($hostIp == null ? 43 : $hostIp.hashCode());
            String $hostPortSpec = this.getHostPortSpec();
            result = result * 59 + ($hostPortSpec == null ? 43 : $hostPortSpec.hashCode());
            return result;
        }
    }
}

