/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.com.github.dockerjava.transport;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import dev.monosoul.jooq.shadow.com.github.dockerjava.transport.DomainSocket;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

class BsdDomainSocket
extends DomainSocket {
    private static final int MAX_PATH_LENGTH = 104;

    BsdDomainSocket(String path) throws IOException {
        super(path);
    }

    @Override
    protected void connect(String path, int handle) {
        SockaddrUn address = new SockaddrUn(1, path.getBytes(StandardCharsets.UTF_8));
        this.connect(handle, address, address.size());
    }

    private native int connect(int var1, SockaddrUn var2, int var3) throws LastErrorException;

    static {
        Native.register((String)Platform.C_LIBRARY_NAME);
    }

    public static class SockaddrUn
    extends Structure
    implements Structure.ByReference {
        public byte sunLen;
        public byte sunFamily;
        public byte[] sunPath = new byte[104];

        private SockaddrUn(byte sunFamily, byte[] path) {
            if (path.length > 104) {
                throw new IllegalArgumentException("Path cannot exceed 104 bytes");
            }
            System.arraycopy(path, 0, this.sunPath, 0, path.length);
            this.sunPath[path.length] = 0;
            this.sunLen = (byte)(this.fieldOffset("sunPath") + path.length);
            this.sunFamily = sunFamily;
            this.allocateMemory();
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("sunLen", "sunFamily", "sunPath");
        }
    }
}

