/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http2.protocol;

import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.EntityDetails;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpException;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequest;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.Method;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ProtocolException;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ProtocolVersion;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.message.MessageSupport;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol.RequestContent;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2RequestContent
extends RequestContent {
    public H2RequestContent() {
    }

    public H2RequestContent(boolean overwrite) {
        super(overwrite);
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(context, "HTTP context");
        ProtocolVersion ver = context.getProtocolVersion();
        if (ver.getMajor() < 2) {
            super.process(request, entity, context);
        } else if (entity != null) {
            String method = request.getMethod();
            if (Method.TRACE.isSame(method)) {
                throw new ProtocolException("TRACE request may not enclose an entity");
            }
            MessageSupport.addContentTypeHeader(request, entity);
            MessageSupport.addContentEncodingHeader(request, entity);
            MessageSupport.addTrailerHeader(request, entity);
        }
    }
}

