/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.rnorth.ducttape.inconsistents;

import dev.monosoul.jooq.shadow.org.jetbrains.annotations.NotNull;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.Preconditions;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.inconsistents.InconsistentResultsException;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.inconsistents.ResultsNeverConsistentException;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.unreliables.Unreliables;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Inconsistents {
    public static <T> T retryUntilConsistent(int consistentTime, int totalTimeout, @NotNull TimeUnit timeUnit, @NotNull Callable<T> lambda) {
        Preconditions.check("consistent time must be greater than 0", consistentTime > 0);
        Preconditions.check("total timeout must be greater than 0", totalTimeout > 0);
        long start = System.currentTimeMillis();
        Object[] recentValue = new Object[]{null};
        long[] firstRecentValueTime = new long[]{0L};
        long[] bestRun = new long[]{0L};
        Object[] bestRunValue = new Object[]{null};
        long consistentTimeInMillis = TimeUnit.MILLISECONDS.convert(consistentTime, timeUnit);
        return (T)Unreliables.retryUntilSuccess(totalTimeout, timeUnit, () -> {
            boolean valueIsSame;
            Object value = lambda.call();
            boolean bl = valueIsSame = value == recentValue[0] || value != null && value.equals(recentValue[0]);
            if (valueIsSame) {
                long now = System.currentTimeMillis();
                long timeSinceFirstValue = now - firstRecentValueTime[0];
                if (timeSinceFirstValue > bestRun[0]) {
                    bestRun[0] = timeSinceFirstValue;
                    bestRunValue[0] = value;
                }
                if (timeSinceFirstValue > consistentTimeInMillis) {
                    return value;
                }
            } else {
                recentValue[0] = value;
                firstRecentValueTime[0] = System.currentTimeMillis();
            }
            long timeSinceStart = System.currentTimeMillis() - start;
            if (bestRun[0] > 0L) {
                throw new InconsistentResultsException(timeSinceStart, bestRunValue[0], bestRun[0]);
            }
            throw new ResultsNeverConsistentException(timeSinceStart);
        });
    }
}

