/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.rnorth.ducttape.ratelimits;

import dev.monosoul.jooq.shadow.org.jetbrains.annotations.NotNull;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.ratelimits.RateLimiter;
import java.util.concurrent.TimeUnit;

class ConstantThroughputRateLimiter
extends RateLimiter {
    private final long timeBetweenInvocations;

    ConstantThroughputRateLimiter(@NotNull Integer rate, @NotNull TimeUnit perTimeUnit) {
        this.timeBetweenInvocations = perTimeUnit.toMillis(1L) / (long)rate.intValue();
    }

    @Override
    protected long getWaitBeforeNextInvocation() {
        long timeToNextAllowed = this.lastInvocation + this.timeBetweenInvocations - System.currentTimeMillis();
        return Math.max(timeToNextAllowed, 0L);
    }
}

