/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.rnorth.ducttape.ratelimits;

import dev.monosoul.jooq.shadow.org.rnorth.ducttape.Preconditions;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.ratelimits.ConstantThroughputRateLimiter;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.ratelimits.RateLimiter;
import java.util.concurrent.TimeUnit;

public class RateLimiterBuilder {
    private Integer invocations;
    private TimeUnit perTimeUnit;
    private RateLimiterStrategy strategy;

    private RateLimiterBuilder() {
    }

    public static RateLimiterBuilder newBuilder() {
        return new RateLimiterBuilder();
    }

    public RateLimiterBuilder withRate(int invocations, TimeUnit perTimeUnit) {
        this.invocations = invocations;
        this.perTimeUnit = perTimeUnit;
        return this;
    }

    public RateLimiterBuilder withConstantThroughput() {
        this.strategy = RateLimiterStrategy.CONSTANT_THROUGHPUT;
        return this;
    }

    public RateLimiter build() {
        Preconditions.check("A rate must be set", this.invocations != null);
        Preconditions.check("A rate must be set", this.perTimeUnit != null);
        Preconditions.check("A rate limit strategy must be set", this.strategy != null);
        if (this.strategy == RateLimiterStrategy.CONSTANT_THROUGHPUT) {
            return new ConstantThroughputRateLimiter(this.invocations, this.perTimeUnit);
        }
        throw new IllegalStateException();
    }

    private static enum RateLimiterStrategy {
        CONSTANT_THROUGHPUT;

    }
}

