/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.Bind;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.BindMode;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.ContainerState;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.Network;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.SelinuxContext;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.OutputFrame;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.traits.LinkableContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.wait.strategy.WaitStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.images.ImagePullPolicy;
import dev.monosoul.jooq.shadow.org.testcontainers.images.builder.Transferable;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.LogUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.MountableFile;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public interface Container<SELF extends Container<SELF>>
extends LinkableContainer,
ContainerState {
    default public SELF self() {
        return (SELF)this;
    }

    public void setCommand(@NonNull String var1);

    public void setCommand(String ... var1);

    public void addEnv(String var1, String var2);

    @Deprecated
    default public void addFileSystemBind(String hostPath, String containerPath, BindMode mode) {
        this.addFileSystemBind(hostPath, containerPath, mode, SelinuxContext.SHARED);
    }

    @Deprecated
    public void addFileSystemBind(String var1, String var2, BindMode var3, SelinuxContext var4);

    @Deprecated
    public void addLink(LinkableContainer var1, String var2);

    public void addExposedPort(Integer var1);

    public void addExposedPorts(int ... var1);

    public SELF waitingFor(@NonNull WaitStrategy var1);

    @Deprecated
    default public SELF withFileSystemBind(String hostPath, String containerPath) {
        return this.withFileSystemBind(hostPath, containerPath, BindMode.READ_WRITE);
    }

    @Deprecated
    public SELF withFileSystemBind(String var1, String var2, BindMode var3);

    public SELF withVolumesFrom(Container var1, BindMode var2);

    public SELF withExposedPorts(Integer ... var1);

    @Deprecated
    public SELF withCopyFileToContainer(MountableFile var1, String var2);

    public SELF withCopyToContainer(Transferable var1, String var2);

    public SELF withEnv(String var1, String var2);

    default public SELF withEnv(String key, Function<Optional<String>, String> mapper) {
        Optional<String> oldValue = Optional.ofNullable(this.getEnvMap().get(key));
        return this.withEnv(key, mapper.apply(oldValue));
    }

    public SELF withEnv(Map<String, String> var1);

    public SELF withLabel(String var1, String var2);

    public SELF withLabels(Map<String, String> var1);

    public SELF withCommand(String var1);

    public SELF withCommand(String ... var1);

    public SELF withExtraHost(String var1, String var2);

    public SELF withNetworkMode(String var1);

    public SELF withNetwork(Network var1);

    public SELF withNetworkAliases(String ... var1);

    public SELF withImagePullPolicy(ImagePullPolicy var1);

    @Deprecated
    default public SELF withClasspathResourceMapping(String resourcePath, String containerPath, BindMode mode) {
        this.withClasspathResourceMapping(resourcePath, containerPath, mode, SelinuxContext.SHARED);
        return this.self();
    }

    @Deprecated
    public SELF withClasspathResourceMapping(String var1, String var2, BindMode var3, SelinuxContext var4);

    public SELF withStartupTimeout(Duration var1);

    public SELF withPrivilegedMode(boolean var1);

    public SELF withMinimumRunningDuration(Duration var1);

    public SELF withStartupCheckStrategy(StartupCheckStrategy var1);

    public SELF withWorkingDirectory(String var1);

    public void setDockerImageName(@NonNull String var1);

    @NonNull
    public String getDockerImageName();

    @Deprecated
    public String getTestHostIpAddress();

    default public void followOutput(Consumer<OutputFrame> consumer) {
        LogUtils.followOutput(this.getDockerClient(), this.getContainerId(), consumer);
    }

    default public void followOutput(Consumer<OutputFrame> consumer, OutputFrame.OutputType ... types) {
        LogUtils.followOutput(this.getDockerClient(), this.getContainerId(), consumer, types);
    }

    public SELF withLogConsumer(Consumer<OutputFrame> var1);

    @Override
    public List<String> getPortBindings();

    public List<String> getExtraHosts();

    public Future<String> getImage();

    @Deprecated
    public List<String> getEnv();

    public Map<String, String> getEnvMap();

    public String[] getCommandParts();

    public List<Bind> getBinds();

    @Deprecated
    public Map<String, LinkableContainer> getLinkedContainers();

    public void setExposedPorts(List<Integer> var1);

    public void setPortBindings(List<String> var1);

    public void setExtraHosts(List<String> var1);

    public void setImage(Future<String> var1);

    public void setEnv(List<String> var1);

    public void setCommandParts(String[] var1);

    public void setBinds(List<Bind> var1);

    @Deprecated
    public void setLinkedContainers(Map<String, LinkableContainer> var1);

    public void setWaitStrategy(WaitStrategy var1);

    public static final class ExecResult {
        private final int exitCode;
        private final String stdout;
        private final String stderr;

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecResult)) {
                return false;
            }
            ExecResult other = (ExecResult)o;
            if (this.getExitCode() != other.getExitCode()) {
                return false;
            }
            String this$stdout = this.getStdout();
            String other$stdout = other.getStdout();
            if (this$stdout == null ? other$stdout != null : !this$stdout.equals(other$stdout)) {
                return false;
            }
            String this$stderr = this.getStderr();
            String other$stderr = other.getStderr();
            return !(this$stderr == null ? other$stderr != null : !this$stderr.equals(other$stderr));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExitCode();
            String $stdout = this.getStdout();
            result = result * 59 + ($stdout == null ? 43 : $stdout.hashCode());
            String $stderr = this.getStderr();
            result = result * 59 + ($stderr == null ? 43 : $stderr.hashCode());
            return result;
        }

        public String toString() {
            return "Container.ExecResult(exitCode=" + this.getExitCode() + ", stdout=" + this.getStdout() + ", stderr=" + this.getStderr() + ")";
        }

        ExecResult(int exitCode, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

