/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.DockerClient;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.HealthState;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectContainerResponse;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.exception.DockerException;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.ExposedPort;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.PortBinding;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.Ports;
import dev.monosoul.jooq.shadow.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import dev.monosoul.jooq.shadow.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import dev.monosoul.jooq.shadow.org.apache.commons.compress.utils.IOUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.DockerClientFactory;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.Container;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.ExecConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.ExecInContainerPattern;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.GenericContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.OutputFrame;
import dev.monosoul.jooq.shadow.org.testcontainers.images.builder.Transferable;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.base.Preconditions;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.math.NumberUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.LogUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.MountableFile;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.ThrowingFunction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ContainerState {
    public static final String STATE_HEALTHY = "healthy";

    @Deprecated
    default public String getContainerIpAddress() {
        return this.getHost();
    }

    default public DockerClient getDockerClient() {
        return DockerClientFactory.lazyClient();
    }

    default public String getHost() {
        return DockerClientFactory.instance().dockerHostIpAddress();
    }

    default public boolean isRunning() {
        if (this.getContainerId() == null) {
            return false;
        }
        try {
            Boolean running = this.getCurrentContainerInfo().getState().getRunning();
            return Boolean.TRUE.equals(running);
        }
        catch (DockerException e) {
            return false;
        }
    }

    default public boolean isCreated() {
        if (this.getContainerId() == null) {
            return false;
        }
        try {
            String status = this.getCurrentContainerInfo().getState().getStatus();
            return "created".equalsIgnoreCase(status) || this.isRunning();
        }
        catch (DockerException e) {
            return false;
        }
    }

    default public boolean isHealthy() {
        if (this.getContainerId() == null) {
            return false;
        }
        try {
            InspectContainerResponse inspectContainerResponse = this.getCurrentContainerInfo();
            HealthState health = inspectContainerResponse.getState().getHealth();
            if (health == null) {
                throw new RuntimeException("This container's image does not have a healthcheck declared, so health cannot be determined. Either amend the image or use another approach to determine whether containers are healthy.");
            }
            return STATE_HEALTHY.equals(health.getStatus());
        }
        catch (DockerException e) {
            return false;
        }
    }

    default public InspectContainerResponse getCurrentContainerInfo() {
        return this.getDockerClient().inspectContainerCmd(this.getContainerId()).exec();
    }

    default public Integer getFirstMappedPort() {
        return this.getExposedPorts().stream().findFirst().map(this::getMappedPort).orElseThrow(() -> new IllegalStateException("Container doesn't expose any ports"));
    }

    default public Integer getMappedPort(int originalPort) {
        Preconditions.checkState(this.getContainerId() != null, "Mapped port can only be obtained after the container is started");
        Ports.Binding[] binding = new Ports.Binding[]{};
        InspectContainerResponse containerInfo = this.getContainerInfo();
        if (containerInfo != null) {
            binding = containerInfo.getNetworkSettings().getPorts().getBindings().get(new ExposedPort(originalPort));
        }
        if (binding != null && binding.length > 0 && binding[0] != null) {
            return Integer.valueOf(binding[0].getHostPortSpec());
        }
        throw new IllegalArgumentException("Requested port (" + originalPort + ") is not mapped");
    }

    public List<Integer> getExposedPorts();

    default public List<String> getPortBindings() {
        ArrayList<String> portBindings = new ArrayList<String>();
        Ports hostPortBindings = this.getContainerInfo().getHostConfig().getPortBindings();
        for (Map.Entry<ExposedPort, Ports.Binding[]> binding : hostPortBindings.getBindings().entrySet()) {
            for (Ports.Binding portBinding : binding.getValue()) {
                portBindings.add(String.format("%s:%s", portBinding.toString(), binding.getKey()));
            }
        }
        return portBindings;
    }

    default public List<Integer> getBoundPortNumbers() {
        return this.getPortBindings().stream().map(PortBinding::parse).map(PortBinding::getBinding).map(Ports.Binding::getHostPortSpec).filter(Objects::nonNull).filter(NumberUtils::isNumber).map(Integer::valueOf).filter(port -> port > 0).collect(Collectors.toList());
    }

    default public String getLogs() {
        return LogUtils.getOutput(this.getDockerClient(), this.getContainerId(), new OutputFrame.OutputType[0]);
    }

    default public String getLogs(OutputFrame.OutputType ... types) {
        return LogUtils.getOutput(this.getDockerClient(), this.getContainerId(), types);
    }

    default public String getContainerId() {
        return this.getContainerInfo().getId();
    }

    public InspectContainerResponse getContainerInfo();

    default public Container.ExecResult execInContainer(String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.execInContainer(StandardCharsets.UTF_8, command);
    }

    default public Container.ExecResult execInContainer(Charset outputCharset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainer(this.getDockerClient(), this.getContainerInfo(), outputCharset, command);
    }

    @Deprecated
    default public Container.ExecResult execInContainerWithUser(String user, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainer(this.getDockerClient(), this.getContainerInfo(), ExecConfig.builder().user(user).command(command).build());
    }

    @Deprecated
    default public Container.ExecResult execInContainerWithUser(Charset outputCharset, String user, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainer(this.getDockerClient(), this.getContainerInfo(), outputCharset, ExecConfig.builder().user(user).command(command).build());
    }

    default public Container.ExecResult execInContainer(ExecConfig execConfig) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainer(this.getDockerClient(), this.getContainerInfo(), execConfig);
    }

    default public Container.ExecResult execInContainer(Charset outputCharset, ExecConfig execConfig) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainer(this.getDockerClient(), this.getContainerInfo(), outputCharset, execConfig);
    }

    default public void copyFileToContainer(MountableFile mountableFile, String containerPath) {
        File sourceFile = new File(mountableFile.getResolvedPath());
        if (containerPath.endsWith("/") && sourceFile.isFile()) {
            Logger logger = LoggerFactory.getLogger(GenericContainer.class);
            logger.warn("folder-like containerPath in copyFileToContainer is deprecated, please explicitly specify a file path");
            this.copyFileToContainer((Transferable)mountableFile, containerPath + sourceFile.getName());
        } else {
            this.copyFileToContainer((Transferable)mountableFile, containerPath);
        }
    }

    default public void copyFileToContainer(Transferable transferable, String containerPath) {
        if (this.getContainerId() == null) {
            throw new IllegalStateException("copyFileToContainer can only be used with created / running container");
        }
        try (PipedOutputStream pipedOutputStream = new PipedOutputStream();
             PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
             TarArchiveOutputStream tarArchive = new TarArchiveOutputStream(pipedOutputStream);){
            Thread thread = new Thread(() -> {
                try {
                    tarArchive.setLongFileMode(3);
                    tarArchive.setBigNumberMode(2);
                    transferable.transferTo(tarArchive, containerPath);
                }
                finally {
                    IOUtils.closeQuietly(tarArchive);
                }
            });
            thread.start();
            this.getDockerClient().copyArchiveToContainerCmd(this.getContainerId()).withTarInputStream(pipedInputStream).withRemotePath("/").exec();
            thread.join();
        }
    }

    default public void copyFileFromContainer(String containerPath, String destinationPath) throws IOException, InterruptedException {
        this.copyFileFromContainer(containerPath, (InputStream inputStream) -> {
            try (FileOutputStream output = new FileOutputStream(destinationPath);){
                IOUtils.copy(inputStream, (OutputStream)output);
                Object var3_3 = null;
                return var3_3;
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    default public <T> T copyFileFromContainer(String containerPath, ThrowingFunction<InputStream, T> function) {
        if (this.getContainerId() == null) {
            throw new IllegalStateException("copyFileFromContainer can only be used when the Container is created.");
        }
        DockerClient dockerClient = this.getDockerClient();
        try (InputStream inputStream = dockerClient.copyArchiveFromContainerCmd(this.getContainerId(), containerPath).exec();){
            InputStream inputStream2;
            try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream(inputStream);){
                tarInputStream.getNextTarEntry();
                inputStream2 = function.apply(tarInputStream);
            }
            return (T)inputStream2;
        }
    }
}

