/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers;

import java.util.Arrays;
import java.util.Map;

public class ExecConfig {
    private String[] command;
    private String user;
    private Map<String, String> envVars;
    private String workDir;

    ExecConfig(String[] command, String user, Map<String, String> envVars, String workDir) {
        this.command = command;
        this.user = user;
        this.envVars = envVars;
        this.workDir = workDir;
    }

    public static ExecConfigBuilder builder() {
        return new ExecConfigBuilder();
    }

    public String[] getCommand() {
        return this.command;
    }

    public String getUser() {
        return this.user;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public static class ExecConfigBuilder {
        private String[] command;
        private String user;
        private Map<String, String> envVars;
        private String workDir;

        ExecConfigBuilder() {
        }

        public ExecConfigBuilder command(String[] command) {
            this.command = command;
            return this;
        }

        public ExecConfigBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ExecConfigBuilder envVars(Map<String, String> envVars) {
            this.envVars = envVars;
            return this;
        }

        public ExecConfigBuilder workDir(String workDir) {
            this.workDir = workDir;
            return this;
        }

        public ExecConfig build() {
            return new ExecConfig(this.command, this.user, this.envVars, this.workDir);
        }

        public String toString() {
            return "ExecConfig.ExecConfigBuilder(command=" + Arrays.deepToString(this.command) + ", user=" + this.user + ", envVars=" + this.envVars + ", workDir=" + this.workDir + ")";
        }
    }
}

