/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers.output;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.Frame;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.StreamType;
import java.nio.charset.StandardCharsets;

public class OutputFrame {
    public static final OutputFrame END = new OutputFrame(OutputType.END, null);
    private final OutputType type;
    private final byte[] bytes;

    public OutputFrame(OutputType type, byte[] bytes) {
        this.type = type;
        this.bytes = bytes;
    }

    public OutputType getType() {
        return this.type;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getUtf8String() {
        return this.bytes == null ? "" : new String(this.bytes, StandardCharsets.UTF_8);
    }

    public String getUtf8StringWithoutLineEnding() {
        if (this.bytes == null) {
            return "";
        }
        return new String(this.bytes, 0, this.bytes.length - OutputFrame.determineLineEndingLength(this.bytes), StandardCharsets.UTF_8);
    }

    private static int determineLineEndingLength(byte[] bytes) {
        if (bytes.length > 0) {
            switch (bytes[bytes.length - 1]) {
                case 13: {
                    return 1;
                }
                case 10: {
                    return bytes.length > 1 && bytes[bytes.length - 2] == 13 ? 2 : 1;
                }
            }
        }
        return 0;
    }

    public static OutputFrame forFrame(Frame frame) {
        OutputType outputType = OutputType.forStreamType(frame.getStreamType());
        if (outputType == null) {
            return null;
        }
        return new OutputFrame(outputType, frame.getPayload());
    }

    public static enum OutputType {
        STDOUT,
        STDERR,
        END;


        public static OutputType forStreamType(StreamType streamType) {
            switch (streamType) {
                case RAW: 
                case STDOUT: {
                    return STDOUT;
                }
                case STDERR: {
                    return STDERR;
                }
            }
            return null;
        }
    }
}

