/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers.output;

import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.BaseConsumer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.OutputFrame;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitingConsumer
extends BaseConsumer<WaitingConsumer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitingConsumer.class);
    private LinkedBlockingDeque<OutputFrame> frames = new LinkedBlockingDeque();

    @Override
    public void accept(OutputFrame frame) {
        this.frames.add(frame);
    }

    public LinkedBlockingDeque<OutputFrame> getFrames() {
        return this.frames;
    }

    public void waitUntil(Predicate<OutputFrame> predicate) throws TimeoutException {
        this.waitUntil(predicate, Long.MAX_VALUE, 1);
    }

    public void waitUntil(Predicate<OutputFrame> predicate, int limit, TimeUnit limitUnit) throws TimeoutException {
        this.waitUntil(predicate, limit, limitUnit, 1);
    }

    public void waitUntil(Predicate<OutputFrame> predicate, long limit, TimeUnit limitUnit, int times) throws TimeoutException {
        long timeoutLimitInNanos = limitUnit.toNanos(limit);
        this.waitUntil(predicate, timeoutLimitInNanos, times);
    }

    private void waitUntil(Predicate<OutputFrame> predicate, long timeoutLimitInNanos, int times) throws TimeoutException {
        int numberOfMatches = 0;
        long startTime = System.nanoTime();
        while (System.nanoTime() - startTime < timeoutLimitInNanos) {
            try {
                OutputFrame frame = this.frames.pollLast(100L, TimeUnit.MILLISECONDS);
                if (frame != null) {
                    LOGGER.debug("{}: {}", (Object)frame.getType(), (Object)frame.getUtf8StringWithoutLineEnding());
                    if (predicate.test(frame) && ++numberOfMatches == times) {
                        return;
                    }
                }
                if (!this.frames.isEmpty()) continue;
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new TimeoutException();
    }

    public void waitUntilEnd() {
        try {
            this.waitUntilEnd(Long.MAX_VALUE);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    public void waitUntilEnd(long limit, TimeUnit limitUnit) throws TimeoutException {
        long expiry = limitUnit.toNanos(limit) + System.nanoTime();
        this.waitUntilEnd(expiry);
    }

    private void waitUntilEnd(Long expiry) throws TimeoutException {
        while (System.nanoTime() < expiry) {
            try {
                OutputFrame frame = this.frames.pollLast(100L, TimeUnit.MILLISECONDS);
                if (frame == OutputFrame.END) {
                    return;
                }
                if (!this.frames.isEmpty()) continue;
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new TimeoutException("Expiry time reached before end of output");
    }
}

