/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers.startupcheck;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.DockerClient;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectContainerResponse;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.GenericContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerStatus;

public class IsRunningStartupCheckStrategy
extends StartupCheckStrategy {
    @Override
    public boolean waitUntilStartupSuccessful(GenericContainer<?> container) {
        if (this.checkState(container.getContainerInfo().getState()) == StartupCheckStrategy.StartupStatus.SUCCESSFUL) {
            return true;
        }
        return super.waitUntilStartupSuccessful(container);
    }

    @Override
    public StartupCheckStrategy.StartupStatus checkStartupState(DockerClient dockerClient, String containerId) {
        InspectContainerResponse.ContainerState state = this.getCurrentState(dockerClient, containerId);
        return this.checkState(state);
    }

    private StartupCheckStrategy.StartupStatus checkState(InspectContainerResponse.ContainerState state) {
        if (Boolean.TRUE.equals(state.getRunning())) {
            return StartupCheckStrategy.StartupStatus.SUCCESSFUL;
        }
        if (DockerStatus.isContainerStopped(state)) {
            if (DockerStatus.isContainerExitCodeSuccess(state)) {
                return StartupCheckStrategy.StartupStatus.SUCCESSFUL;
            }
            return StartupCheckStrategy.StartupStatus.FAILED;
        }
        return StartupCheckStrategy.StartupStatus.NOT_YET_KNOWN;
    }
}

