/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers.wait.strategy;

import dev.monosoul.jooq.shadow.org.rnorth.ducttape.ratelimits.RateLimiter;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.wait.strategy.WaitStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;

public abstract class AbstractWaitStrategy
implements WaitStrategy {
    static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactory(){
        private final AtomicLong COUNTER = new AtomicLong(0L);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "testcontainers-wait-" + this.COUNTER.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final RateLimiter DOCKER_CLIENT_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(1, TimeUnit.SECONDS).withConstantThroughput().build();
    protected WaitStrategyTarget waitStrategyTarget;
    @NonNull
    protected Duration startupTimeout = Duration.ofSeconds(60L);
    @NonNull
    private RateLimiter rateLimiter = DOCKER_CLIENT_RATE_LIMITER;

    @Override
    public void waitUntilReady(WaitStrategyTarget waitStrategyTarget) {
        this.waitStrategyTarget = waitStrategyTarget;
        this.waitUntilReady();
    }

    protected abstract void waitUntilReady();

    @Override
    public WaitStrategy withStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
        return this;
    }

    protected Set<Integer> getLivenessCheckPorts() {
        return this.waitStrategyTarget.getLivenessCheckPortNumbers();
    }

    protected RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public WaitStrategy withRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }
}

