/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.delegate;

import dev.monosoul.jooq.shadow.org.testcontainers.delegate.DatabaseDelegate;
import java.util.Collection;

public abstract class AbstractDatabaseDelegate<CONNECTION>
implements DatabaseDelegate {
    private CONNECTION connection;
    private boolean isConnectionStarted = false;

    protected CONNECTION getConnection() {
        if (!this.isConnectionStarted) {
            this.connection = this.createNewConnection();
            this.isConnectionStarted = true;
        }
        return this.connection;
    }

    @Override
    public void execute(Collection<String> statements, String scriptPath, boolean continueOnError, boolean ignoreFailedDrops) {
        int lineNumber = 0;
        for (String statement : statements) {
            this.execute(statement, scriptPath, ++lineNumber, continueOnError, ignoreFailedDrops);
        }
    }

    @Override
    public void close() {
        if (this.isConnectionStarted) {
            this.closeConnectionQuietly(this.connection);
            this.isConnectionStarted = false;
        }
    }

    protected abstract void closeConnectionQuietly(CONNECTION var1);

    protected abstract CONNECTION createNewConnection();
}

