/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.dockerclient;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.DockerClient;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.AttachContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.AuthCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.BuildImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CommitCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ConnectToNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ContainerDiffCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateConfigCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateSecretCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateServiceCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateVolumeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.EventsCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ExecCreateCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ExecStartCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InfoCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InitializeSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectConfigCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectExecCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectServiceCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectVolumeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.JoinSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.KillContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LeaveSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListConfigsCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListContainersCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListImagesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListNetworksCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListSecretsCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListServicesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListSwarmNodesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListTasksCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListVolumesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LoadImageAsyncCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LoadImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LogContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LogSwarmObjectCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PauseContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PingCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PruneCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PullImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PushImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveConfigCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveSecretCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveServiceCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveSwarmNodeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveVolumeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RenameContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ResizeContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ResizeExecCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RestartContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.SaveImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.SaveImagesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.SearchImagesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.StartContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.StatsCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.StopContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.SyncDockerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.TagImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.TopContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UnpauseContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UpdateContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UpdateServiceCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UpdateSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UpdateSwarmNodeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.VersionCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.WaitContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.exception.DockerException;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.AuthConfig;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.Identifier;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.PruneType;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.SecretSpec;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.ServiceSpec;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.SwarmSpec;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.NotNull;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.AuditLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuditLoggingDockerClient
implements DockerClient {
    private static final Logger log = LoggerFactory.getLogger(AuditLoggingDockerClient.class);
    private final DockerClient wrappedClient;

    public AuditLoggingDockerClient(DockerClient wrappedClient) {
        this.wrappedClient = wrappedClient;
    }

    @Override
    public CreateContainerCmd createContainerCmd(@NotNull String image) {
        return this.wrappedCommand(CreateContainerCmd.class, this.wrappedClient.createContainerCmd(image), (cmd, res) -> AuditLogger.doLog("CREATE", image, res.getId(), cmd), (cmd, e) -> AuditLogger.doLog("CREATE", image, null, cmd, e));
    }

    @Override
    public StartContainerCmd startContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(StartContainerCmd.class, this.wrappedClient.startContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("START", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("START", null, containerId, cmd, e));
    }

    @Override
    public RemoveContainerCmd removeContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(RemoveContainerCmd.class, this.wrappedClient.removeContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("REMOVE", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("REMOVE", null, containerId, cmd, e));
    }

    @Override
    public StopContainerCmd stopContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(StopContainerCmd.class, this.wrappedClient.stopContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("STOP", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("STOP", null, containerId, cmd, e));
    }

    @Override
    public KillContainerCmd killContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(KillContainerCmd.class, this.wrappedClient.killContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("KILL", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("KILL", null, containerId, cmd, e));
    }

    @Override
    public CreateNetworkCmd createNetworkCmd() {
        return this.wrappedCommand(CreateNetworkCmd.class, this.wrappedClient.createNetworkCmd(), (cmd, res) -> AuditLogger.doLog("CREATE_NETWORK", null, null, cmd), (cmd, e) -> AuditLogger.doLog("CREATE_NETWORK", null, null, cmd, e));
    }

    @Override
    public RemoveNetworkCmd removeNetworkCmd(@NotNull String networkId) {
        return this.wrappedCommand(RemoveNetworkCmd.class, this.wrappedClient.removeNetworkCmd(networkId), (cmd, res) -> AuditLogger.doLog("REMOVE_NETWORK", null, null, cmd), (cmd, e) -> AuditLogger.doLog("REMOVE_NETWORK", null, null, cmd, e));
    }

    private <T extends SyncDockerCmd<R>, R> T wrappedCommand(Class<T> clazz, T cmd, BiConsumer<T, R> successConsumer, BiConsumer<T, Exception> failureConsumer) {
        return (T)((SyncDockerCmd)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            if (method.getName().equals("exec")) {
                try {
                    Object r = method.invoke((Object)cmd, args);
                    successConsumer.accept(cmd, r);
                    return r;
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException && e.getCause() instanceof Exception) {
                        e = (Exception)e.getCause();
                    }
                    failureConsumer.accept(cmd, e);
                    throw e;
                }
            }
            return method.invoke((Object)cmd, args);
        }));
    }

    @Override
    public AuthConfig authConfig() throws DockerException {
        return this.wrappedClient.authConfig();
    }

    @Override
    public AuthCmd authCmd() {
        return this.wrappedClient.authCmd();
    }

    @Override
    public InfoCmd infoCmd() {
        return this.wrappedClient.infoCmd();
    }

    @Override
    public PingCmd pingCmd() {
        return this.wrappedClient.pingCmd();
    }

    @Override
    public VersionCmd versionCmd() {
        return this.wrappedClient.versionCmd();
    }

    @Override
    public PullImageCmd pullImageCmd(String repository) {
        return this.wrappedClient.pullImageCmd(repository);
    }

    @Override
    public PushImageCmd pushImageCmd(String name) {
        return this.wrappedClient.pushImageCmd(name);
    }

    @Override
    public PushImageCmd pushImageCmd(Identifier identifier) {
        return this.wrappedClient.pushImageCmd(identifier);
    }

    @Override
    public CreateImageCmd createImageCmd(String repository, InputStream imageStream) {
        return this.wrappedClient.createImageCmd(repository, imageStream);
    }

    @Override
    public LoadImageCmd loadImageCmd(InputStream imageStream) {
        return this.wrappedClient.loadImageCmd(imageStream);
    }

    @Override
    public LoadImageAsyncCmd loadImageAsyncCmd(InputStream imageStream) {
        return this.wrappedClient.loadImageAsyncCmd(imageStream);
    }

    @Override
    public SearchImagesCmd searchImagesCmd(String term) {
        return this.wrappedClient.searchImagesCmd(term);
    }

    @Override
    public RemoveImageCmd removeImageCmd(String imageId) {
        return this.wrappedClient.removeImageCmd(imageId);
    }

    @Override
    public ListImagesCmd listImagesCmd() {
        return this.wrappedClient.listImagesCmd();
    }

    @Override
    public InspectImageCmd inspectImageCmd(String imageId) {
        return this.wrappedClient.inspectImageCmd(imageId);
    }

    @Override
    public SaveImageCmd saveImageCmd(String name) {
        return this.wrappedClient.saveImageCmd(name);
    }

    @Override
    public SaveImagesCmd saveImagesCmd() {
        return this.wrappedClient.saveImagesCmd();
    }

    @Override
    public ListContainersCmd listContainersCmd() {
        return this.wrappedClient.listContainersCmd();
    }

    @Override
    public ExecCreateCmd execCreateCmd(String containerId) {
        return this.wrappedClient.execCreateCmd(containerId);
    }

    @Override
    public ResizeExecCmd resizeExecCmd(String execId) {
        return this.wrappedClient.resizeExecCmd(execId);
    }

    @Override
    public InspectContainerCmd inspectContainerCmd(String containerId) {
        return this.wrappedClient.inspectContainerCmd(containerId);
    }

    @Override
    public WaitContainerCmd waitContainerCmd(String containerId) {
        return this.wrappedClient.waitContainerCmd(containerId);
    }

    @Override
    public AttachContainerCmd attachContainerCmd(String containerId) {
        return this.wrappedClient.attachContainerCmd(containerId);
    }

    @Override
    public ExecStartCmd execStartCmd(String execId) {
        return this.wrappedClient.execStartCmd(execId);
    }

    @Override
    public InspectExecCmd inspectExecCmd(String execId) {
        return this.wrappedClient.inspectExecCmd(execId);
    }

    @Override
    public LogContainerCmd logContainerCmd(String containerId) {
        return this.wrappedClient.logContainerCmd(containerId);
    }

    @Override
    public CopyArchiveFromContainerCmd copyArchiveFromContainerCmd(String containerId, String resource) {
        return this.wrappedClient.copyArchiveFromContainerCmd(containerId, resource);
    }

    @Override
    @Deprecated
    public CopyFileFromContainerCmd copyFileFromContainerCmd(String containerId, String resource) {
        return this.wrappedClient.copyFileFromContainerCmd(containerId, resource);
    }

    @Override
    public CopyArchiveToContainerCmd copyArchiveToContainerCmd(String containerId) {
        return this.wrappedClient.copyArchiveToContainerCmd(containerId);
    }

    @Override
    public ContainerDiffCmd containerDiffCmd(String containerId) {
        return this.wrappedClient.containerDiffCmd(containerId);
    }

    @Override
    public UpdateContainerCmd updateContainerCmd(String containerId) {
        return this.wrappedClient.updateContainerCmd(containerId);
    }

    @Override
    public RenameContainerCmd renameContainerCmd(String containerId) {
        return this.wrappedClient.renameContainerCmd(containerId);
    }

    @Override
    public RestartContainerCmd restartContainerCmd(String containerId) {
        return this.wrappedClient.restartContainerCmd(containerId);
    }

    @Override
    public ResizeContainerCmd resizeContainerCmd(String containerId) {
        return this.wrappedClient.resizeContainerCmd(containerId);
    }

    @Override
    public CommitCmd commitCmd(String containerId) {
        return this.wrappedClient.commitCmd(containerId);
    }

    @Override
    public BuildImageCmd buildImageCmd() {
        return this.wrappedClient.buildImageCmd();
    }

    @Override
    public BuildImageCmd buildImageCmd(File dockerFileOrFolder) {
        return this.wrappedClient.buildImageCmd(dockerFileOrFolder);
    }

    @Override
    public BuildImageCmd buildImageCmd(InputStream tarInputStream) {
        return this.wrappedClient.buildImageCmd(tarInputStream);
    }

    @Override
    public TopContainerCmd topContainerCmd(String containerId) {
        return this.wrappedClient.topContainerCmd(containerId);
    }

    @Override
    public TagImageCmd tagImageCmd(String imageId, String imageNameWithRepository, String tag) {
        return this.wrappedClient.tagImageCmd(imageId, imageNameWithRepository, tag);
    }

    @Override
    public PauseContainerCmd pauseContainerCmd(String containerId) {
        return this.wrappedClient.pauseContainerCmd(containerId);
    }

    @Override
    public UnpauseContainerCmd unpauseContainerCmd(String containerId) {
        return this.wrappedClient.unpauseContainerCmd(containerId);
    }

    @Override
    public EventsCmd eventsCmd() {
        return this.wrappedClient.eventsCmd();
    }

    @Override
    public StatsCmd statsCmd(String containerId) {
        return this.wrappedClient.statsCmd(containerId);
    }

    @Override
    public CreateVolumeCmd createVolumeCmd() {
        return this.wrappedClient.createVolumeCmd();
    }

    @Override
    public InspectVolumeCmd inspectVolumeCmd(String name) {
        return this.wrappedClient.inspectVolumeCmd(name);
    }

    @Override
    public RemoveVolumeCmd removeVolumeCmd(String name) {
        return this.wrappedClient.removeVolumeCmd(name);
    }

    @Override
    public ListVolumesCmd listVolumesCmd() {
        return this.wrappedClient.listVolumesCmd();
    }

    @Override
    public ListNetworksCmd listNetworksCmd() {
        return this.wrappedClient.listNetworksCmd();
    }

    @Override
    public InspectNetworkCmd inspectNetworkCmd() {
        return this.wrappedClient.inspectNetworkCmd();
    }

    @Override
    public ConnectToNetworkCmd connectToNetworkCmd() {
        return this.wrappedClient.connectToNetworkCmd();
    }

    @Override
    public DisconnectFromNetworkCmd disconnectFromNetworkCmd() {
        return this.wrappedClient.disconnectFromNetworkCmd();
    }

    @Override
    public InitializeSwarmCmd initializeSwarmCmd(SwarmSpec swarmSpec) {
        return this.wrappedClient.initializeSwarmCmd(swarmSpec);
    }

    @Override
    public InspectSwarmCmd inspectSwarmCmd() {
        return this.wrappedClient.inspectSwarmCmd();
    }

    @Override
    public JoinSwarmCmd joinSwarmCmd() {
        return this.wrappedClient.joinSwarmCmd();
    }

    @Override
    public LeaveSwarmCmd leaveSwarmCmd() {
        return this.wrappedClient.leaveSwarmCmd();
    }

    @Override
    public UpdateSwarmCmd updateSwarmCmd(SwarmSpec swarmSpec) {
        return this.wrappedClient.updateSwarmCmd(swarmSpec);
    }

    @Override
    public UpdateSwarmNodeCmd updateSwarmNodeCmd() {
        return this.wrappedClient.updateSwarmNodeCmd();
    }

    @Override
    public RemoveSwarmNodeCmd removeSwarmNodeCmd(String swarmNodeId) {
        return this.wrappedClient.removeSwarmNodeCmd(swarmNodeId);
    }

    @Override
    public ListSwarmNodesCmd listSwarmNodesCmd() {
        return this.wrappedClient.listSwarmNodesCmd();
    }

    @Override
    public ListServicesCmd listServicesCmd() {
        return this.wrappedClient.listServicesCmd();
    }

    @Override
    public CreateServiceCmd createServiceCmd(ServiceSpec serviceSpec) {
        return this.wrappedClient.createServiceCmd(serviceSpec);
    }

    @Override
    public InspectServiceCmd inspectServiceCmd(String serviceId) {
        return this.wrappedClient.inspectServiceCmd(serviceId);
    }

    @Override
    public UpdateServiceCmd updateServiceCmd(String serviceId, ServiceSpec serviceSpec) {
        return this.wrappedClient.updateServiceCmd(serviceId, serviceSpec);
    }

    @Override
    public RemoveServiceCmd removeServiceCmd(String serviceId) {
        return this.wrappedClient.removeServiceCmd(serviceId);
    }

    @Override
    public ListTasksCmd listTasksCmd() {
        return this.wrappedClient.listTasksCmd();
    }

    @Override
    public LogSwarmObjectCmd logServiceCmd(String serviceId) {
        return this.wrappedClient.logServiceCmd(serviceId);
    }

    @Override
    public LogSwarmObjectCmd logTaskCmd(String taskId) {
        return this.wrappedClient.logTaskCmd(taskId);
    }

    @Override
    public PruneCmd pruneCmd(PruneType pruneType) {
        return this.wrappedClient.pruneCmd(pruneType);
    }

    @Override
    public ListSecretsCmd listSecretsCmd() {
        return this.wrappedClient.listSecretsCmd();
    }

    @Override
    public CreateSecretCmd createSecretCmd(SecretSpec secretSpec) {
        return this.wrappedClient.createSecretCmd(secretSpec);
    }

    @Override
    public RemoveSecretCmd removeSecretCmd(String secretId) {
        return this.wrappedClient.removeSecretCmd(secretId);
    }

    @Override
    public ListConfigsCmd listConfigsCmd() {
        return this.wrappedClient.listConfigsCmd();
    }

    @Override
    public CreateConfigCmd createConfigCmd() {
        return this.wrappedClient.createConfigCmd();
    }

    @Override
    public InspectConfigCmd inspectConfigCmd(String configId) {
        return this.wrappedClient.inspectConfigCmd(configId);
    }

    @Override
    public RemoveConfigCmd removeConfigCmd(String configId) {
        return this.wrappedClient.removeConfigCmd(configId);
    }

    @Override
    public void close() throws IOException {
        this.wrappedClient.close();
    }

    private static interface InterceptedMethods {
        public CreateContainerCmd createContainerCmd(String var1);

        public StartContainerCmd startContainerCmd(String var1);

        public RemoveContainerCmd removeContainerCmd(String var1);

        public StopContainerCmd stopContainerCmd(String var1);

        public KillContainerCmd killContainerCmd(String var1);

        public CreateNetworkCmd createNetworkCmd();

        public RemoveNetworkCmd removeNetworkCmd(String var1);
    }
}

