/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.dockerclient;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.AuthConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfigDelegate;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.AuthConfigUtil;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.RegistryAuthLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthDelegatingDockerClientConfig
extends DockerClientConfigDelegate {
    private static final Logger log = LoggerFactory.getLogger(AuthDelegatingDockerClientConfig.class);

    public AuthDelegatingDockerClientConfig(DockerClientConfig delegate) {
        super(delegate);
    }

    @Override
    public AuthConfig effectiveAuthConfig(String imageName) {
        AuthConfig fallbackAuthConfig;
        try {
            fallbackAuthConfig = super.effectiveAuthConfig(imageName);
        }
        catch (Exception e) {
            log.debug("Delegate call to effectiveAuthConfig failed with cause: '{}'. Resolution of auth config will continue using RegistryAuthLocator.", (Object)e.getMessage());
            fallbackAuthConfig = new AuthConfig();
        }
        DockerImageName parsed = DockerImageName.parse(imageName);
        AuthConfig effectiveAuthConfig = RegistryAuthLocator.instance().lookupAuthConfig(parsed, fallbackAuthConfig);
        log.debug("Effective auth config [{}]", (Object)AuthConfigUtil.toSafeString(effectiveAuthConfig));
        return effectiveAuthConfig;
    }
}

