/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.dockerclient;

import dev.monosoul.jooq.shadow.org.testcontainers.DockerClientFactory;
import dev.monosoul.jooq.shadow.org.testcontainers.dockerclient.LogToStringContainerCallback;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerClientConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(DockerClientConfigUtils.class);
    public static final boolean IN_A_CONTAINER = new File("/.dockerenv").exists();
    private static final AtomicReference<Object> defaultGateway = new AtomicReference();

    @Deprecated
    public static String getDockerHostIpAddress(URI dockerHost) {
        switch (dockerHost.getScheme()) {
            case "http": 
            case "https": 
            case "tcp": {
                return dockerHost.getHost();
            }
            case "unix": 
            case "npipe": {
                if (IN_A_CONTAINER) {
                    return DockerClientConfigUtils.getDefaultGateway().orElse("localhost");
                }
                return "localhost";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<String> getDefaultGateway() {
        Object value = defaultGateway.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = defaultGateway;
            synchronized (atomicReference) {
                value = defaultGateway.get();
                if (value == null) {
                    Optional<String> actualValue = Optional.ofNullable(DockerClientFactory.instance().runInsideDocker(cmd -> cmd.withCmd("sh", "-c", "ip route|awk '/default/ { print $3 }'"), (client, id) -> {
                        try {
                            LogToStringContainerCallback loggingCallback = new LogToStringContainerCallback();
                            client.logContainerCmd((String)id).withStdOut(true).withFollowStream(true).exec(loggingCallback).awaitStarted();
                            loggingCallback.awaitCompletion(3L, TimeUnit.SECONDS);
                            return loggingCallback.toString();
                        }
                        catch (Exception e) {
                            log.warn("Can't parse the default gateway IP", (Throwable)e);
                            return null;
                        }
                    })).map(StringUtils::trimToEmpty).filter(StringUtils::isNotBlank);
                    value = actualValue == null ? defaultGateway : actualValue;
                    defaultGateway.set(value);
                }
            }
        }
        return (Optional)(value == defaultGateway ? null : value);
    }
}

