/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.images;

import dev.monosoul.jooq.shadow.org.testcontainers.images.AgeBasedPullPolicy;
import dev.monosoul.jooq.shadow.org.testcontainers.images.AlwaysPullPolicy;
import dev.monosoul.jooq.shadow.org.testcontainers.images.DefaultPullPolicy;
import dev.monosoul.jooq.shadow.org.testcontainers.images.ImagePullPolicy;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.TestcontainersConfiguration;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PullPolicy {
    private static final Logger log = LoggerFactory.getLogger(PullPolicy.class);
    @VisibleForTesting
    static ImagePullPolicy instance;
    @VisibleForTesting
    static ImagePullPolicy defaultImplementation;

    public static synchronized ImagePullPolicy defaultPolicy() {
        if (instance != null) {
            return instance;
        }
        String imagePullPolicyClassName = TestcontainersConfiguration.getInstance().getImagePullPolicy();
        if (imagePullPolicyClassName != null) {
            ImagePullPolicy configuredInstance;
            log.debug("Attempting to instantiate an ImagePullPolicy with class: {}", (Object)imagePullPolicyClassName);
            try {
                configuredInstance = (ImagePullPolicy)Thread.currentThread().getContextClassLoader().loadClass(imagePullPolicyClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Configured ImagePullPolicy could not be loaded: " + imagePullPolicyClassName, e);
            }
            log.info("Found configured Image Pull Policy: {}", configuredInstance.getClass());
            instance = configuredInstance;
        } else {
            instance = defaultImplementation;
        }
        log.info("Image pull policy will be performed by: {}", (Object)instance);
        return instance;
    }

    public static ImagePullPolicy alwaysPull() {
        return new AlwaysPullPolicy();
    }

    public static ImagePullPolicy ageBased(Duration maxAge) {
        return new AgeBasedPullPolicy(maxAge);
    }

    private PullPolicy() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        defaultImplementation = new DefaultPullPolicy();
    }
}

