/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.images.builder;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.DockerClient;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.BuildImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.BuildImageResultCallback;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.BuildResponseItem;
import dev.monosoul.jooq.shadow.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import dev.monosoul.jooq.shadow.org.testcontainers.DockerClientFactory;
import dev.monosoul.jooq.shadow.org.testcontainers.images.ParsedDockerfile;
import dev.monosoul.jooq.shadow.org.testcontainers.images.RemoteDockerImage;
import dev.monosoul.jooq.shadow.org.testcontainers.images.builder.Transferable;
import dev.monosoul.jooq.shadow.org.testcontainers.images.builder.traits.BuildContextBuilderTrait;
import dev.monosoul.jooq.shadow.org.testcontainers.images.builder.traits.ClasspathTrait;
import dev.monosoul.jooq.shadow.org.testcontainers.images.builder.traits.DockerfileTrait;
import dev.monosoul.jooq.shadow.org.testcontainers.images.builder.traits.FilesTrait;
import dev.monosoul.jooq.shadow.org.testcontainers.images.builder.traits.StringsTrait;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.io.FileUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.Base58;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerLoggerFactory;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.ImageNameSubstitutor;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.LazyFuture;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.ResourceReaper;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageFromDockerfile
extends LazyFuture<String>
implements BuildContextBuilderTrait<ImageFromDockerfile>,
ClasspathTrait<ImageFromDockerfile>,
FilesTrait<ImageFromDockerfile>,
StringsTrait<ImageFromDockerfile>,
DockerfileTrait<ImageFromDockerfile> {
    private static final Logger log = LoggerFactory.getLogger(ImageFromDockerfile.class);
    private final String dockerImageName;
    private boolean deleteOnExit = true;
    private final Map<String, Transferable> transferables = new HashMap<String, Transferable>();
    private final Map<String, String> buildArgs = new HashMap<String, String>();
    private Optional<String> dockerFilePath = Optional.empty();
    private Optional<Path> dockerfile = Optional.empty();
    private Optional<String> target = Optional.empty();
    private final Set<Consumer<BuildImageCmd>> buildImageCmdModifiers = new LinkedHashSet<Consumer<BuildImageCmd>>();
    private Set<String> dependencyImageNames = Collections.emptySet();

    public ImageFromDockerfile() {
        this("localhost/testcontainers/" + Base58.randomString(16).toLowerCase());
    }

    public ImageFromDockerfile(String dockerImageName) {
        this(dockerImageName, true);
    }

    public ImageFromDockerfile(String dockerImageName, boolean deleteOnExit) {
        this.dockerImageName = dockerImageName;
        this.deleteOnExit = deleteOnExit;
    }

    @Override
    public ImageFromDockerfile withFileFromTransferable(String path, Transferable transferable) {
        Transferable oldValue = this.transferables.put(path, transferable);
        if (oldValue != null) {
            log.warn("overriding previous mapping for '{}'", (Object)path);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final String resolve() {
        final Logger logger = DockerLoggerFactory.getLogger(this.dockerImageName);
        DockerClient dockerClient = DockerClientFactory.instance().client();
        try {
            BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

                @Override
                public void onNext(BuildResponseItem item) {
                    super.onNext(item);
                    if (item.isErrorIndicated()) {
                        logger.error(item.getErrorDetail().getMessage());
                    } else {
                        logger.debug(StringUtils.removeEnd(item.getStream(), "\n"));
                    }
                }
            };
            PipedInputStream in = new PipedInputStream();
            try {
                String string;
                block20: {
                    PipedOutputStream out = new PipedOutputStream(in);
                    try {
                        BuildImageCmd buildImageCmd = dockerClient.buildImageCmd(in);
                        this.configure(buildImageCmd);
                        HashMap<String, String> labels = new HashMap<String, String>();
                        if (buildImageCmd.getLabels() != null) {
                            labels.putAll(buildImageCmd.getLabels());
                        }
                        labels.putAll(DockerClientFactory.DEFAULT_LABELS);
                        if (this.deleteOnExit) {
                            labels.putAll(ResourceReaper.instance().getLabels());
                        }
                        buildImageCmd.withLabels(labels);
                        this.prePullDependencyImages(this.dependencyImageNames);
                        BuildImageResultCallback exec = buildImageCmd.exec(resultCallback);
                        long bytesToDockerDaemon = 0L;
                        try (TarArchiveOutputStream tarArchive = new TarArchiveOutputStream(new GZIPOutputStream(out));){
                            tarArchive.setLongFileMode(3);
                            tarArchive.setBigNumberMode(2);
                            for (Map.Entry<String, Transferable> entry : this.transferables.entrySet()) {
                                Transferable transferable = entry.getValue();
                                String destination = entry.getKey();
                                transferable.transferTo(tarArchive, destination);
                                bytesToDockerDaemon += transferable.getSize();
                            }
                            tarArchive.finish();
                        }
                        log.info("Transferred {} to Docker daemon", (Object)FileUtils.byteCountToDisplaySize(bytesToDockerDaemon));
                        if (bytesToDockerDaemon > 0x3200000L) {
                            log.warn("A large amount of data was sent to the Docker daemon ({}). Consider using a .dockerignore file for better performance.", (Object)FileUtils.byteCountToDisplaySize(bytesToDockerDaemon));
                        }
                        exec.awaitImageId();
                        string = this.dockerImageName;
                        if (Collections.singletonList(out).get(0) == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(out).get(0) != null) {
                            out.close();
                        }
                        throw throwable;
                    }
                    out.close();
                }
                return string;
            }
            finally {
                if (Collections.singletonList(in).get(0) != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't close DockerClient", e);
        }
    }

    protected void configure(BuildImageCmd buildImageCmd) {
        buildImageCmd.withTags(Collections.singleton(this.getDockerImageName()));
        this.dockerFilePath.ifPresent(buildImageCmd::withDockerfilePath);
        this.dockerfile.ifPresent(p -> {
            buildImageCmd.withDockerfile(p.toFile());
            this.dependencyImageNames = new ParsedDockerfile((Path)p).getDependencyImageNames();
            if (this.dependencyImageNames.size() > 0) {
                buildImageCmd.withPull(false);
            }
        });
        this.buildArgs.forEach(buildImageCmd::withBuildArg);
        this.target.ifPresent(buildImageCmd::withTarget);
        this.buildImageCmdModifiers.forEach(hook -> hook.accept(buildImageCmd));
    }

    private void prePullDependencyImages(Set<String> imagesToPull) {
        imagesToPull.forEach(imageName -> {
            String resolvedImageName = this.applyBuildArgsToImageName((String)imageName);
            try {
                log.info("Pre-emptively checking local images for '{}', referenced via a Dockerfile. If not available, it will be pulled.", (Object)resolvedImageName);
                new RemoteDockerImage(DockerImageName.parse(resolvedImageName)).withImageNameSubstitutor(ImageNameSubstitutor.noop()).get();
            }
            catch (Exception e) {
                log.warn("Unable to pre-fetch an image ({}) depended upon by Dockerfile - image build will continue but may fail. Exception message was: {}", (Object)resolvedImageName, (Object)e.getMessage());
            }
        });
    }

    private String applyBuildArgsToImageName(String imageName) {
        for (Map.Entry<String, String> entry : this.buildArgs.entrySet()) {
            String value = Matcher.quoteReplacement(entry.getValue());
            imageName = imageName.replace("$" + entry.getKey(), value);
            imageName = imageName.replace("${" + entry.getKey() + "}", value);
        }
        return imageName;
    }

    public ImageFromDockerfile withBuildArg(String key, String value) {
        this.buildArgs.put(key, value);
        return this;
    }

    public ImageFromDockerfile withBuildArgs(Map<String, String> args) {
        this.buildArgs.putAll(args);
        return this;
    }

    public ImageFromDockerfile withTarget(String target) {
        this.target = Optional.of(target);
        return this;
    }

    @Deprecated
    public ImageFromDockerfile withDockerfilePath(String relativePathFromBuildContextDirectory) {
        this.dockerFilePath = Optional.of(relativePathFromBuildContextDirectory);
        return this;
    }

    public ImageFromDockerfile withDockerfile(Path dockerfile) {
        this.dockerfile = Optional.of(dockerfile);
        return this;
    }

    public ImageFromDockerfile withBuildImageCmdModifier(Consumer<BuildImageCmd> modifier) {
        this.buildImageCmdModifiers.add(modifier);
        return this;
    }

    public String getDockerImageName() {
        return this.dockerImageName;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public Map<String, Transferable> getTransferables() {
        return this.transferables;
    }

    public Map<String, String> getBuildArgs() {
        return this.buildArgs;
    }

    public Optional<String> getDockerFilePath() {
        return this.dockerFilePath;
    }

    public Optional<Path> getDockerfile() {
        return this.dockerfile;
    }

    public Optional<String> getTarget() {
        return this.target;
    }

    public Set<Consumer<BuildImageCmd>> getBuildImageCmdModifiers() {
        return this.buildImageCmdModifiers;
    }

    public Set<String> getDependencyImageNames() {
        return this.dependencyImageNames;
    }
}

