/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.jdbc;

import dev.monosoul.jooq.shadow.org.testcontainers.containers.JdbcDatabaseContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.delegate.AbstractDatabaseDelegate;
import dev.monosoul.jooq.shadow.org.testcontainers.exception.ConnectionCreationException;
import dev.monosoul.jooq.shadow.org.testcontainers.ext.ScriptUtils;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDatabaseDelegate
extends AbstractDatabaseDelegate<Statement> {
    private static final Logger log = LoggerFactory.getLogger(JdbcDatabaseDelegate.class);
    private JdbcDatabaseContainer container;
    private String queryString;

    public JdbcDatabaseDelegate(JdbcDatabaseContainer container, String queryString) {
        this.container = container;
        this.queryString = queryString;
    }

    @Override
    protected Statement createNewConnection() {
        try {
            return this.container.createConnection(this.queryString).createStatement();
        }
        catch (SQLException e) {
            log.error("Could not obtain JDBC connection");
            throw new ConnectionCreationException("Could not obtain JDBC connection", e);
        }
    }

    @Override
    public void execute(String statement, String scriptPath, int lineNumber, boolean continueOnError, boolean ignoreFailedDrops) {
        try {
            boolean rowsAffected = ((Statement)this.getConnection()).execute(statement);
            log.debug("{} returned as updateCount for SQL: {}", (Object)rowsAffected, (Object)statement);
        }
        catch (SQLException ex) {
            boolean dropStatement = statement.trim().toLowerCase().startsWith("drop");
            if (continueOnError || dropStatement && ignoreFailedDrops) {
                log.debug("Failed to execute SQL script statement at line {} of resource {}: {}", new Object[]{lineNumber, scriptPath, statement, ex});
            }
            throw new ScriptUtils.ScriptStatementFailedException(statement, lineNumber, scriptPath, ex);
        }
    }

    @Override
    protected void closeConnectionQuietly(Statement statement) {
        try {
            statement.close();
        }
        catch (Exception e) {
            log.error("Could not close JDBC connection", (Throwable)e);
        }
    }
}

