/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core;

import dev.monosoul.jooq.shadow.com.github.dockerjava.transport.DockerHttpClient;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.AbstractDockerCmdExecFactory;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.DefaultInvocationBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.InvocationBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.RemoteApiVersion;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.WebTarget;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.HashMultimap;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.ImmutableCollection;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.ImmutableList;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.MultimapBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.SetMultimap;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.escape.Escaper;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.net.UrlEscapers;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class DefaultDockerCmdExecFactory
extends AbstractDockerCmdExecFactory {
    private final DockerHttpClient dockerHttpClient;
    private final ObjectMapper objectMapper;

    public DefaultDockerCmdExecFactory(DockerHttpClient dockerHttpClient, ObjectMapper objectMapper) {
        this.dockerHttpClient = dockerHttpClient;
        this.objectMapper = objectMapper;
    }

    public DockerHttpClient getDockerHttpClient() {
        return this.dockerHttpClient;
    }

    @Override
    protected WebTarget getBaseResource() {
        return new DefaultWebTarget();
    }

    @Override
    public void close() throws IOException {
        this.dockerHttpClient.close();
    }

    private class DefaultWebTarget
    implements WebTarget {
        final ImmutableList<String> path;
        final SetMultimap<String, String> queryParams;

        DefaultWebTarget() {
            this(ImmutableList.of(), (SetMultimap<String, String>)MultimapBuilder.hashKeys().hashSetValues().build());
        }

        DefaultWebTarget(ImmutableList<String> path, SetMultimap<String, String> queryParams) {
            this.path = path;
            this.queryParams = queryParams;
        }

        public String toString() {
            return String.format("DefaultWebTarget{path=%s, queryParams=%s}", this.path, this.queryParams);
        }

        @Override
        public InvocationBuilder request() {
            RemoteApiVersion apiVersion;
            String resource = StringUtils.join(this.path, "/");
            if (!resource.startsWith("/")) {
                resource = "/" + resource;
            }
            if ((apiVersion = DefaultDockerCmdExecFactory.this.getDockerClientConfig().getApiVersion()) != RemoteApiVersion.UNKNOWN_VERSION) {
                resource = "/" + apiVersion.asWebPathPart() + resource;
            }
            if (!this.queryParams.isEmpty()) {
                Escaper urlFormParameterEscaper = UrlEscapers.urlFormParameterEscaper();
                resource = this.queryParams.asMap().entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(s2 -> (String)entry.getKey() + "=" + urlFormParameterEscaper.escape((String)s2))).collect(Collectors.joining("&", resource + "?", ""));
            }
            return new DefaultInvocationBuilder(DefaultDockerCmdExecFactory.this.dockerHttpClient, DefaultDockerCmdExecFactory.this.objectMapper, resource);
        }

        @Override
        public DefaultWebTarget path(String ... components) {
            ImmutableCollection newPath = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.path)).add(components)).build();
            return new DefaultWebTarget((ImmutableList<String>)newPath, this.queryParams);
        }

        @Override
        public DefaultWebTarget resolveTemplate(String name, Object value) {
            ImmutableList.Builder newPath = ImmutableList.builder();
            for (String component : this.path) {
                component = component.replaceAll("\\{" + name + "\\}", UrlEscapers.urlPathSegmentEscaper().escape(value.toString()));
                newPath.add(component);
            }
            return new DefaultWebTarget((ImmutableList<String>)newPath.build(), this.queryParams);
        }

        @Override
        public DefaultWebTarget queryParam(String name, Object value) {
            if (value == null) {
                return this;
            }
            HashMultimap<String, String> newQueryParams = HashMultimap.create(this.queryParams);
            newQueryParams.put(name, value.toString());
            return new DefaultWebTarget(this.path, newQueryParams);
        }

        @Override
        public DefaultWebTarget queryParamsSet(String name, Set<?> values) {
            HashMultimap<String, String> newQueryParams = HashMultimap.create(this.queryParams);
            newQueryParams.replaceValues((Object)name, values.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
            return new DefaultWebTarget(this.path, newQueryParams);
        }

        @Override
        public DefaultWebTarget queryParamsJsonMap(String name, Map<String, String> values) {
            if (values == null || values.isEmpty()) {
                return this;
            }
            try {
                return this.queryParam(name, DefaultDockerCmdExecFactory.this.objectMapper.writeValueAsString(values));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

