/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.exception.DockerClientException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.SSLConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.util.CertificateUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class LocalDirectorySSLConfig
implements SSLConfig,
Serializable {
    private static final long serialVersionUID = -4736328026418377358L;
    private final String dockerCertPath;

    public LocalDirectorySSLConfig(String dockerCertPath) {
        this.dockerCertPath = Objects.requireNonNull(dockerCertPath);
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    @Override
    public SSLContext getSSLContext() {
        boolean certificatesExist = CertificateUtils.verifyCertificatesExist(this.dockerCertPath);
        if (certificatesExist) {
            try {
                Security.addProvider(new BouncyCastleProvider());
                String caPemPath = this.dockerCertPath + File.separator + "ca.pem";
                String keyPemPath = this.dockerCertPath + File.separator + "key.pem";
                String certPemPath = this.dockerCertPath + File.separator + "cert.pem";
                String keypem = new String(Files.readAllBytes(Paths.get(keyPemPath, new String[0])));
                String certpem = new String(Files.readAllBytes(Paths.get(certPemPath, new String[0])));
                String capem = new String(Files.readAllBytes(Paths.get(caPemPath, new String[0])));
                String kmfAlgorithm = AccessController.doPrivileged(this.getSystemProperty("ssl.keyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm()));
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(kmfAlgorithm);
                keyManagerFactory.init(CertificateUtils.createKeyStore(keypem, certpem), "docker".toCharArray());
                String tmfAlgorithm = AccessController.doPrivileged(this.getSystemProperty("ssl.trustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm()));
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
                trustManagerFactory.init(CertificateUtils.createTrustStore(capem));
                SSLContext sslContext = SSLContext.getInstance(AccessController.doPrivileged(this.getSystemProperty("ssl.protocol", "TLSv1.2")));
                sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                return sslContext;
            }
            catch (Exception e) {
                throw new DockerClientException(e.getMessage(), e);
            }
        }
        return null;
    }

    private PrivilegedAction<String> getSystemProperty(String name, String def) {
        return () -> System.getProperty(name, def);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDirectorySSLConfig that = (LocalDirectorySSLConfig)o;
        return this.dockerCertPath.equals(that.dockerCertPath);
    }

    public int hashCode() {
        return this.dockerCertPath.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "dockerCertPath=" + this.dockerCertPath + "}";
    }
}

