/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.util.concurrent;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.annotations.GwtIncompatible;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.annotations.J2ktIncompatible;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.base.Preconditions;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.util.concurrent.ExecutionError;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.util.concurrent.ParametricNullness;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.util.concurrent.Platform;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.util.concurrent.TimeLimiter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class FakeTimeLimiter
implements TimeLimiter {
    @Override
    @CanIgnoreReturnValue
    public <T> T newProxy(T target, Class<T> interfaceType, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        return target;
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Exception e) {
            Platform.restoreInterruptIfIsInterruptedException(e);
            throw new ExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        return this.callWithTimeout(callable, timeoutDuration, timeoutUnit);
    }

    @Override
    public void runWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            runnable.run();
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        this.runWithTimeout(runnable, timeoutDuration, timeoutUnit);
    }
}

