/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.trilead.ssh2.signature;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.trilead.ssh2.crypto.digest.SHA1;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.trilead.ssh2.log.Logger;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.trilead.ssh2.packets.TypesReader;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.trilead.ssh2.packets.TypesWriter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.trilead.ssh2.signature.DSAPrivateKey;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.trilead.ssh2.signature.DSAPublicKey;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.trilead.ssh2.signature.DSASignature;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSASHA1Verify {
    private static final Logger log = Logger.getLogger(class$com$trilead$ssh2$signature$DSASHA1Verify == null ? (class$com$trilead$ssh2$signature$DSASHA1Verify = DSASHA1Verify.class$("dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.trilead.ssh2.signature.DSASHA1Verify")) : class$com$trilead$ssh2$signature$DSASHA1Verify);
    static /* synthetic */ Class class$com$trilead$ssh2$signature$DSASHA1Verify;

    public static DSAPublicKey decodeSSHDSAPublicKey(byte[] key) throws IOException {
        TypesReader tr = new TypesReader(key);
        String key_format = tr.readString();
        if (!key_format.equals("ssh-dss")) {
            throw new IllegalArgumentException("This is not a ssh-dss public key!");
        }
        BigInteger p = tr.readMPINT();
        BigInteger q = tr.readMPINT();
        BigInteger g2 = tr.readMPINT();
        BigInteger y = tr.readMPINT();
        if (tr.remain() != 0) {
            throw new IOException("Padding in DSA public key!");
        }
        return new DSAPublicKey(p, q, g2, y);
    }

    public static byte[] encodeSSHDSAPublicKey(DSAPublicKey pk) throws IOException {
        TypesWriter tw = new TypesWriter();
        tw.writeString("ssh-dss");
        tw.writeMPInt(pk.getP());
        tw.writeMPInt(pk.getQ());
        tw.writeMPInt(pk.getG());
        tw.writeMPInt(pk.getY());
        return tw.getBytes();
    }

    public static byte[] encodeSSHDSASignature(DSASignature ds) {
        TypesWriter tw = new TypesWriter();
        tw.writeString("ssh-dss");
        byte[] r = ds.getR().toByteArray();
        byte[] s2 = ds.getS().toByteArray();
        byte[] a40 = new byte[40];
        int r_copylen = r.length < 20 ? r.length : 20;
        int s_copylen = s2.length < 20 ? s2.length : 20;
        System.arraycopy(r, r.length - r_copylen, a40, 20 - r_copylen, r_copylen);
        System.arraycopy(s2, s2.length - s_copylen, a40, 40 - s_copylen, s_copylen);
        tw.writeString(a40, 0, 40);
        return tw.getBytes();
    }

    public static DSASignature decodeSSHDSASignature(byte[] sig) throws IOException {
        TypesReader tr = new TypesReader(sig);
        String sig_format = tr.readString();
        if (!sig_format.equals("ssh-dss")) {
            throw new IOException("Peer sent wrong signature format");
        }
        byte[] rsArray = tr.readByteString();
        if (rsArray.length != 40) {
            throw new IOException("Peer sent corrupt signature");
        }
        if (tr.remain() != 0) {
            throw new IOException("Padding in DSA signature!");
        }
        byte[] tmp = new byte[20];
        System.arraycopy(rsArray, 0, tmp, 0, 20);
        BigInteger r = new BigInteger(1, tmp);
        System.arraycopy(rsArray, 20, tmp, 0, 20);
        BigInteger s2 = new BigInteger(1, tmp);
        if (log.isEnabled()) {
            log.log(30, "decoded ssh-dss signature: first bytes r(" + (rsArray[0] & 0xFF) + "), s(" + (rsArray[20] & 0xFF) + ")");
        }
        return new DSASignature(r, s2);
    }

    public static boolean verifySignature(byte[] message, DSASignature ds, DSAPublicKey dpk) throws IOException {
        SHA1 md = new SHA1();
        md.update(message);
        byte[] sha_message = new byte[md.getDigestLength()];
        md.digest(sha_message);
        BigInteger m4 = new BigInteger(1, sha_message);
        BigInteger r = ds.getR();
        BigInteger s2 = ds.getS();
        BigInteger g2 = dpk.getG();
        BigInteger p = dpk.getP();
        BigInteger q = dpk.getQ();
        BigInteger y = dpk.getY();
        BigInteger zero = BigInteger.ZERO;
        if (log.isEnabled()) {
            log.log(60, "ssh-dss signature: m: " + m4.toString(16));
            log.log(60, "ssh-dss signature: r: " + r.toString(16));
            log.log(60, "ssh-dss signature: s: " + s2.toString(16));
            log.log(60, "ssh-dss signature: g: " + g2.toString(16));
            log.log(60, "ssh-dss signature: p: " + p.toString(16));
            log.log(60, "ssh-dss signature: q: " + q.toString(16));
            log.log(60, "ssh-dss signature: y: " + y.toString(16));
        }
        if (zero.compareTo(r) >= 0 || q.compareTo(r) <= 0) {
            log.log(20, "ssh-dss signature: zero.compareTo(r) >= 0 || q.compareTo(r) <= 0");
            return false;
        }
        if (zero.compareTo(s2) >= 0 || q.compareTo(s2) <= 0) {
            log.log(20, "ssh-dss signature: zero.compareTo(s) >= 0 || q.compareTo(s) <= 0");
            return false;
        }
        BigInteger w = s2.modInverse(q);
        BigInteger u1 = m4.multiply(w).mod(q);
        BigInteger u2 = r.multiply(w).mod(q);
        u1 = g2.modPow(u1, p);
        u2 = y.modPow(u2, p);
        BigInteger v = u1.multiply(u2).mod(p).mod(q);
        return v.equals(r);
    }

    public static DSASignature generateSignature(byte[] message, DSAPrivateKey pk, SecureRandom rnd) {
        BigInteger k;
        SHA1 md = new SHA1();
        md.update(message);
        byte[] sha_message = new byte[md.getDigestLength()];
        md.digest(sha_message);
        BigInteger m4 = new BigInteger(1, sha_message);
        int qBitLength = pk.getQ().bitLength();
        while ((k = new BigInteger(qBitLength, rnd)).compareTo(pk.getQ()) >= 0) {
        }
        BigInteger r = pk.getG().modPow(k, pk.getP()).mod(pk.getQ());
        k = k.modInverse(pk.getQ()).multiply(m4.add(pk.getX().multiply(r)));
        BigInteger s2 = k.mod(pk.getQ());
        return new DSASignature(r, s2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

