/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core;

import java.lang.reflect.Method;

class LambdaErrorMessageGenerator {
    private static final String LAMBDA_CLASS_NAME = "$$Lambda$";
    private static final String LAMBDA_METHOD_NAME = "$Lambda";

    LambdaErrorMessageGenerator() {
    }

    static boolean isLambdaClass(Class<?> cls) {
        return cls.getSimpleName().contains(LAMBDA_CLASS_NAME);
    }

    static String generateLambdaErrorMessagePrefix(Class<?> lambdaClass, boolean firstLetterLowerCaseAndEndWithColon) {
        String name = lambdaClass.getName();
        int indexOfLambda = name.indexOf(LAMBDA_CLASS_NAME);
        String nameWithoutLambda = name.substring(0, indexOfLambda);
        nameWithoutLambda = LambdaErrorMessageGenerator.addLambdaDetailsIfFound(lambdaClass, nameWithoutLambda, firstLetterLowerCaseAndEndWithColon);
        return nameWithoutLambda;
    }

    private static String addLambdaDetailsIfFound(Class<?> supplierClass, String nameWithoutLambda, boolean firstLetterUpperCaseAndEndWithColon) {
        Class<?>[] lambdaParams;
        String nameToReturn = nameWithoutLambda;
        Method[] declaredMethods = supplierClass.getDeclaredMethods();
        Method lambdaMethod = null;
        for (Method declaredMethod : declaredMethods) {
            if (!declaredMethod.getName().contains(LAMBDA_METHOD_NAME)) continue;
            lambdaMethod = declaredMethod;
            break;
        }
        if (lambdaMethod != null && (lambdaParams = lambdaMethod.getParameterTypes()).length > 0) {
            StringBuilder nameToReturnBuilder = new StringBuilder(firstLetterUpperCaseAndEndWithColon ? "L" : "l").append("ambda expression in ").append(nameToReturn);
            if (nameWithoutLambda.equals(lambdaParams[0].getName())) {
                if (firstLetterUpperCaseAndEndWithColon) {
                    nameToReturnBuilder.append(':');
                }
            } else {
                nameToReturnBuilder.append(" that uses ");
                for (int i = 0; i < lambdaParams.length; ++i) {
                    Class<?> lambdaParam = lambdaParams[i];
                    nameToReturnBuilder.append(lambdaParam.getName());
                    if (i + 1 == lambdaParams.length) {
                        if (!firstLetterUpperCaseAndEndWithColon) continue;
                        nameToReturnBuilder.append(':');
                        continue;
                    }
                    nameToReturnBuilder.append(", ").append(lambdaParam.getName());
                }
            }
            nameToReturn = nameToReturnBuilder.toString();
        }
        return nameToReturn;
    }
}

