/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cert;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.ASN1BitString;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Encodable;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Integer;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Sequence;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.DERBitString;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.DERSequence;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.DERTaggedObject;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.x509.Certificate;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.x509.Extension;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.x509.ExtensionsGenerator;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cert.X509CertificateHolder;
import java.io.IOException;

public class DeltaCertificateTool {
    public static final int signature = 1;
    public static final int issuer = 2;
    public static final int validity = 4;
    public static final int subject = 8;
    public static final int extensions = 16;

    public static Extension makeDeltaCertificateExtension(boolean bl, int n, X509CertificateHolder x509CertificateHolder) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(x509CertificateHolder.getSerialNumber()));
        if ((n & 1) != 0) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, (ASN1Encodable)x509CertificateHolder.getSignatureAlgorithm()));
        }
        if ((n & 2) != 0) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)x509CertificateHolder.getIssuer()));
        }
        if ((n & 4) != 0) {
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector(2);
            aSN1EncodableVector2.add(x509CertificateHolder.toASN1Structure().getStartDate());
            aSN1EncodableVector2.add(x509CertificateHolder.toASN1Structure().getEndDate());
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, (ASN1Encodable)new DERSequence(aSN1EncodableVector2)));
        }
        if ((n & 8) != 0) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 3, (ASN1Encodable)x509CertificateHolder.getSubject()));
        }
        aSN1EncodableVector.add(x509CertificateHolder.getSubjectPublicKeyInfo());
        if ((n & 0x10) != 0 && x509CertificateHolder.getExtensions() != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 4, (ASN1Encodable)x509CertificateHolder.getExtensions()));
        }
        aSN1EncodableVector.add(new DERBitString(x509CertificateHolder.getSignature()));
        return new Extension(new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.1"), bl, new DERSequence(aSN1EncodableVector).getEncoded("DER"));
    }

    public static X509CertificateHolder extractDeltaCertificate(X509CertificateHolder x509CertificateHolder) {
        Object object;
        Object object2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.1");
        Extension extension = x509CertificateHolder.getExtension(aSN1ObjectIdentifier);
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(extension.getParsedValue());
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(x509CertificateHolder.toASN1Structure().getTBSCertificate().toASN1Primitive());
        int n = 0;
        ASN1Encodable[] aSN1EncodableArray = aSN1Sequence2.toArray();
        aSN1EncodableArray[0] = aSN1Sequence2.getObjectAt(0);
        aSN1EncodableArray[1] = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n++));
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(n++);
        while (aSN1Encodable instanceof ASN1TaggedObject) {
            object2 = ASN1TaggedObject.getInstance(aSN1Encodable);
            switch (((ASN1TaggedObject)object2).getTagNo()) {
                case 0: {
                    aSN1EncodableArray[2] = ASN1Sequence.getInstance((ASN1TaggedObject)object2, false);
                    break;
                }
                case 1: {
                    aSN1EncodableArray[3] = ASN1Sequence.getInstance((ASN1TaggedObject)object2, true);
                    break;
                }
                case 2: {
                    aSN1EncodableArray[4] = ASN1Sequence.getInstance((ASN1TaggedObject)object2, false);
                    break;
                }
                case 3: {
                    aSN1EncodableArray[5] = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Encodable, true);
                }
            }
            aSN1Encodable = aSN1Sequence.getObjectAt(n++);
        }
        aSN1EncodableArray[6] = aSN1Encodable;
        if (aSN1EncodableArray[2] == null) {
            aSN1EncodableArray[2] = aSN1Sequence2.getObjectAt(2);
        }
        if (aSN1EncodableArray[3] == null) {
            aSN1EncodableArray[3] = aSN1Sequence2.getObjectAt(3);
        }
        if (aSN1EncodableArray[4] == null) {
            aSN1EncodableArray[4] = aSN1Sequence2.getObjectAt(4);
        }
        if (aSN1EncodableArray[5] == null) {
            aSN1EncodableArray[5] = aSN1Sequence2.getObjectAt(5);
        }
        object2 = DeltaCertificateTool.extractExtensions(aSN1Sequence2);
        if (n < aSN1Sequence.size() - 1) {
            if (((ASN1TaggedObject)(object = ASN1TaggedObject.getInstance(aSN1Encodable = aSN1Sequence.getObjectAt(n++)))).getTagNo() != 4) {
                throw new IllegalArgumentException("malformed delta extension");
            }
            ASN1Sequence aSN1Sequence3 = ASN1Sequence.getInstance((ASN1TaggedObject)object, false);
            for (int i = 0; i != aSN1Sequence3.size(); ++i) {
                ((ExtensionsGenerator)object2).replaceExtension(Extension.getInstance(aSN1Sequence3.getObjectAt(i)));
            }
            aSN1EncodableArray[7] = new DERTaggedObject(3, ((ExtensionsGenerator)object2).generate());
        } else {
            if (!((ExtensionsGenerator)object2).isEmpty()) {
                aSN1EncodableArray[7] = ((ExtensionsGenerator)object2).generate();
            }
            aSN1EncodableArray[7] = null;
        }
        object = new ASN1EncodableVector(7);
        for (int i = 0; i != aSN1EncodableArray.length; ++i) {
            if (aSN1EncodableArray[i] == null) continue;
            ((ASN1EncodableVector)object).add(aSN1EncodableArray[i]);
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERSequence((ASN1EncodableVector)object));
        aSN1EncodableVector.add(ASN1Sequence.getInstance(aSN1EncodableArray[2]));
        aSN1EncodableVector.add(ASN1BitString.getInstance(aSN1Sequence.getObjectAt(aSN1Sequence.size() - 1)));
        return new X509CertificateHolder(Certificate.getInstance(new DERSequence(aSN1EncodableVector)));
    }

    private static ExtensionsGenerator extractExtensions(ASN1Sequence aSN1Sequence) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.1");
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(aSN1Sequence.size() - 1)), true);
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        for (int i = 0; i != aSN1Sequence2.size(); ++i) {
            Extension extension = Extension.getInstance(aSN1Sequence2.getObjectAt(i));
            if (aSN1ObjectIdentifier.equals(extension.getExtnId())) continue;
            extensionsGenerator.addExtension(extension);
        }
        return extensionsGenerator;
    }
}

