/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cms;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.DEROctetString;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.RecipientIdentifier;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.RecipientInfo;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cms.CMSException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cms.RecipientInfoGenerator;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.operator.AsymmetricKeyWrapper;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.operator.GenericKey;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerialNumber, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.issuerAndSerial = issuerAndSerialNumber;
        this.wrapper = asymmetricKeyWrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] byArray, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.subjectKeyIdentifier = byArray;
        this.wrapper = asymmetricKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        try {
            byArray = this.wrapper.generateWrappedKey(genericKey);
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
        RecipientIdentifier recipientIdentifier = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipientIdentifier, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(byArray)));
    }
}

