/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.agreement;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.BasicAgreement;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.CipherParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.agreement.Utils;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.math.ec.ECAlgorithms;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHCBasicAgreement
implements BasicAgreement {
    ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("ECCDH", this.key));
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)cipherParameters;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        if (!eCDomainParameters.equals(eCPublicKeyParameters.getParameters())) {
            throw new IllegalStateException("ECDHC public key has wrong domain parameters");
        }
        BigInteger bigInteger = eCDomainParameters.getH().multiply(this.key.getD()).mod(eCDomainParameters.getN());
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPublicKeyParameters.getQ());
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDHC");
        }
        return eCPoint2.getAffineXCoord().toBigInteger();
    }
}

