/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.constraints;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.CryptoServiceConstraintsException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.CryptoServiceProperties;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.constraints.ServicesConstraint;
import java.util.Collections;
import java.util.Set;

public class BitsOfSecurityConstraint
extends ServicesConstraint {
    private final int requiredBitsOfSecurity;

    public BitsOfSecurityConstraint(int n) {
        super(Collections.EMPTY_SET);
        this.requiredBitsOfSecurity = n;
    }

    public BitsOfSecurityConstraint(int n, Set<String> set) {
        super(set);
        this.requiredBitsOfSecurity = n;
    }

    @Override
    public void check(CryptoServiceProperties cryptoServiceProperties) {
        if (this.isException(cryptoServiceProperties.getServiceName())) {
            return;
        }
        if (cryptoServiceProperties.bitsOfSecurity() < this.requiredBitsOfSecurity) {
            throw new CryptoServiceConstraintsException("service does not provide " + this.requiredBitsOfSecurity + " bits of security only " + cryptoServiceProperties.bitsOfSecurity());
        }
    }
}

