/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.ec;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.CipherParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.ec.ECPair;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.ec.ECPairFactorTransform;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.ec.ECUtil;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.math.ec.ECAlgorithms;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.math.ec.ECMultiplier;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.math.ec.ECPoint;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNewRandomnessTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private SecureRandom random;
    private BigInteger lastK;

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
            }
            this.key = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (!(cipherParameters instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
            }
            this.key = (ECPublicKeyParameters)cipherParameters;
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    @Override
    public ECPair transform(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECNewRandomnessTransform not initialised");
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger = eCDomainParameters.getN();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        BigInteger bigInteger2 = ECUtil.generateK(bigInteger, this.random);
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger2).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPair.getX())), this.key.getQ().multiply(bigInteger2).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPair.getY()))};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        this.lastK = bigInteger2;
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    @Override
    public BigInteger getTransformValue() {
        return this.lastK;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

