/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.eac;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Encodable;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.DEROctetString;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.DERTaggedObject;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.eac.CVCertificate;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.eac.CertificateBody;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.eac.CertificateHolderReference;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.eac.CertificationAuthorityReference;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.eac.PackedDate;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.eac.PublicKeyDataObject;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.eac.EACCertificateHolder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.eac.EACException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.eac.operator.EACSigner;
import java.io.OutputStream;

public class EACCertificateBuilder {
    private static final byte[] ZeroArray = new byte[]{0};
    private PublicKeyDataObject publicKey;
    private CertificateHolderAuthorization certificateHolderAuthorization;
    private PackedDate certificateEffectiveDate;
    private PackedDate certificateExpirationDate;
    private CertificateHolderReference certificateHolderReference;
    private CertificationAuthorityReference certificationAuthorityReference;

    public EACCertificateBuilder(CertificationAuthorityReference certificationAuthorityReference, PublicKeyDataObject publicKeyDataObject, CertificateHolderReference certificateHolderReference, CertificateHolderAuthorization certificateHolderAuthorization, PackedDate packedDate, PackedDate packedDate2) {
        this.certificationAuthorityReference = certificationAuthorityReference;
        this.publicKey = publicKeyDataObject;
        this.certificateHolderReference = certificateHolderReference;
        this.certificateHolderAuthorization = certificateHolderAuthorization;
        this.certificateEffectiveDate = packedDate;
        this.certificateExpirationDate = packedDate2;
    }

    private CertificateBody buildBody() {
        DERTaggedObject dERTaggedObject = new DERTaggedObject(false, 64, 41, (ASN1Encodable)new DEROctetString(ZeroArray));
        CertificateBody certificateBody = new CertificateBody(dERTaggedObject, this.certificationAuthorityReference, this.publicKey, this.certificateHolderReference, this.certificateHolderAuthorization, this.certificateEffectiveDate, this.certificateExpirationDate);
        return certificateBody;
    }

    public EACCertificateHolder build(EACSigner eACSigner) throws EACException {
        try {
            CertificateBody certificateBody = this.buildBody();
            OutputStream outputStream = eACSigner.getOutputStream();
            outputStream.write(certificateBody.getEncoded("DER"));
            outputStream.close();
            return new EACCertificateHolder(new CVCertificate(certificateBody, eACSigner.getSignature()));
        }
        catch (Exception exception) {
            throw new EACException("unable to process signature: " + exception.getMessage(), exception);
        }
    }
}

