/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pkcs.jcajce;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.x509.Certificate;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.operator.OutputEncryptor;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pkcs.PKCS12SafeBagBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pkcs.PKCSIOException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaPKCS12SafeBagBuilder
extends PKCS12SafeBagBuilder {
    public JcaPKCS12SafeBagBuilder(X509Certificate x509Certificate) throws IOException {
        super(JcaPKCS12SafeBagBuilder.convertCert(x509Certificate));
    }

    private static Certificate convertCert(X509Certificate x509Certificate) throws IOException {
        try {
            return Certificate.getInstance(x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new PKCSIOException("cannot encode certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey, OutputEncryptor outputEncryptor) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()), outputEncryptor);
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

