/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.lms;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.Digest;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.lms.LMSParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.lms.LMSigParameters;

class LmsUtils {
    LmsUtils() {
    }

    static void u32str(int n, Digest digest) {
        digest.update((byte)(n >>> 24));
        digest.update((byte)(n >>> 16));
        digest.update((byte)(n >>> 8));
        digest.update((byte)n);
    }

    static void u16str(short s2, Digest digest) {
        digest.update((byte)(s2 >>> 8));
        digest.update((byte)s2);
    }

    static void byteArray(byte[] byArray, Digest digest) {
        digest.update(byArray, 0, byArray.length);
    }

    static void byteArray(byte[] byArray, int n, int n2, Digest digest) {
        digest.update(byArray, n, n2);
    }

    static int calculateStrength(LMSParameters lMSParameters) {
        if (lMSParameters == null) {
            throw new NullPointerException("lmsParameters cannot be null");
        }
        LMSigParameters lMSigParameters = lMSParameters.getLMSigParam();
        return (1 << lMSigParameters.getH()) * lMSigParameters.getM();
    }
}

