/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.hamcrest.text;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.hamcrest.Description;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.hamcrest.Matcher;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.hamcrest.TypeSafeMatcher;
import java.util.Arrays;

public class StringContainsInOrder
extends TypeSafeMatcher<String> {
    private final Iterable<String> substrings;

    public StringContainsInOrder(Iterable<String> substrings) {
        this.substrings = substrings;
    }

    @Override
    public boolean matchesSafely(String s2) {
        int fromIndex = 0;
        for (String substring : this.substrings) {
            fromIndex = s2.indexOf(substring, fromIndex);
            if (fromIndex == -1) {
                return false;
            }
            ++fromIndex;
        }
        return true;
    }

    @Override
    public void describeMismatchSafely(String item, Description mismatchDescription) {
        mismatchDescription.appendText("was \"").appendText(item).appendText("\"");
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("a string containing ").appendValueList("", ", ", "", this.substrings).appendText(" in order");
    }

    public static Matcher<String> stringContainsInOrder(Iterable<String> substrings) {
        return new StringContainsInOrder(substrings);
    }

    public static Matcher<String> stringContainsInOrder(String ... substrings) {
        return new StringContainsInOrder(Arrays.asList(substrings));
    }
}

