/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.close;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.close.ExceptionUtil;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.close.ProcessCloser;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stream.ExecuteStreamHandler;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardProcessCloser
implements ProcessCloser {
    private static final Logger log = LoggerFactory.getLogger(StandardProcessCloser.class);
    protected final ExecuteStreamHandler streams;

    public StandardProcessCloser(ExecuteStreamHandler streams) {
        this.streams = streams;
    }

    @Override
    public void close(Process process) throws IOException, InterruptedException {
        if (this.streams != null) {
            this.streams.stop();
        }
        this.closeStreams(process);
    }

    private void closeStreams(Process process) throws IOException {
        IOException caught = null;
        try {
            process.getOutputStream().close();
        }
        catch (IOException e) {
            if (e.getMessage().equals("Stream closed")) {
                log.trace("Failed to close process output stream:", (Throwable)e);
            }
            caught = StandardProcessCloser.add(caught, e);
        }
        try {
            process.getInputStream().close();
        }
        catch (IOException e) {
            caught = StandardProcessCloser.add(caught, e);
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException e) {
            caught = StandardProcessCloser.add(caught, e);
        }
        if (caught != null) {
            throw caught;
        }
    }

    private static IOException add(IOException exception, IOException newException) {
        if (exception == null) {
            return newException;
        }
        ExceptionUtil.addSuppressed(exception, newException);
        return exception;
    }
}

