/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.utility;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DefaultImageNameSubstitutor;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.TestcontainersConfiguration;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageNameSubstitutor
implements Function<DockerImageName, DockerImageName> {
    private static final Logger log = LoggerFactory.getLogger(ImageNameSubstitutor.class);
    @VisibleForTesting
    static ImageNameSubstitutor instance;
    @VisibleForTesting
    static ImageNameSubstitutor defaultImplementation;

    public static synchronized ImageNameSubstitutor instance() {
        return ImageNameSubstitutor.instance(Thread.currentThread().getContextClassLoader());
    }

    @VisibleForTesting
    static synchronized ImageNameSubstitutor instance(ClassLoader classLoader) {
        if (instance == null) {
            ImageNameSubstitutor configuredInstance = ImageNameSubstitutor.getImageNameSubstitutor(classLoader);
            if (configuredInstance != null) {
                log.debug("Attempting to instantiate an ImageNameSubstitutor with class: {}", (Object)configuredInstance.getClass().getCanonicalName());
                log.info("Found configured ImageNameSubstitutor: {}", (Object)configuredInstance.getDescription());
                instance = new ChainedImageNameSubstitutor(ImageNameSubstitutor.wrapWithLogging(defaultImplementation), ImageNameSubstitutor.wrapWithLogging(configuredInstance));
            } else {
                instance = ImageNameSubstitutor.wrapWithLogging(defaultImplementation);
            }
            log.info("Image name substitution will be performed by: {}", (Object)instance.getDescription());
        }
        return instance;
    }

    private static ImageNameSubstitutor getImageNameSubstitutor(ClassLoader classLoader) {
        String configuredClassName = TestcontainersConfiguration.getInstance().getImageSubstitutorClassName();
        if (configuredClassName != null) {
            try {
                return (ImageNameSubstitutor)classLoader.loadClass(configuredClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Configured Image Substitutor could not be loaded: " + configuredClassName, e);
            }
        }
        return StreamSupport.stream(ServiceLoader.load(ImageNameSubstitutor.class, classLoader).spliterator(), false).findFirst().orElse(null);
    }

    public static ImageNameSubstitutor noop() {
        return new NoopImageNameSubstitutor();
    }

    private static ImageNameSubstitutor wrapWithLogging(ImageNameSubstitutor wrappedInstance) {
        return new LogWrappedImageNameSubstitutor(wrappedInstance);
    }

    @Override
    public abstract DockerImageName apply(DockerImageName var1);

    protected abstract String getDescription();

    static {
        defaultImplementation = new DefaultImageNameSubstitutor();
    }

    static class ChainedImageNameSubstitutor
    extends ImageNameSubstitutor {
        private final ImageNameSubstitutor defaultInstance;
        private final ImageNameSubstitutor configuredInstance;

        public ChainedImageNameSubstitutor(ImageNameSubstitutor defaultInstance, ImageNameSubstitutor configuredInstance) {
            this.defaultInstance = defaultInstance;
            this.configuredInstance = configuredInstance;
        }

        @Override
        public DockerImageName apply(DockerImageName original) {
            return this.defaultInstance.andThen(this.configuredInstance).apply(original);
        }

        @Override
        protected String getDescription() {
            return String.format("Chained substitutor of '%s' and then '%s'", this.defaultInstance.getDescription(), this.configuredInstance.getDescription());
        }

        public String toString() {
            return this.getDescription();
        }
    }

    private static class NoopImageNameSubstitutor
    extends ImageNameSubstitutor {
        private NoopImageNameSubstitutor() {
        }

        @Override
        public DockerImageName apply(DockerImageName original) {
            return original;
        }

        @Override
        protected String getDescription() {
            return "No-op substitutor";
        }
    }

    static class LogWrappedImageNameSubstitutor
    extends ImageNameSubstitutor {
        @VisibleForTesting
        final ImageNameSubstitutor wrappedInstance;

        public LogWrappedImageNameSubstitutor(ImageNameSubstitutor wrappedInstance) {
            this.wrappedInstance = wrappedInstance;
        }

        @Override
        public DockerImageName apply(DockerImageName original) {
            DockerImageName replacementImage = this.wrappedInstance.apply(original);
            if (!replacementImage.equals(original)) {
                log.info("Using {} as a substitute image for {} (using image substitutor: {})", new Object[]{replacementImage.asCanonicalNameString(), original.asCanonicalNameString(), this.wrappedInstance.getDescription()});
                return replacementImage;
            }
            log.debug("Did not find a substitute image for {} (using image substitutor: {})", (Object)original.asCanonicalNameString(), (Object)this.wrappedInstance.getDescription());
            return original;
        }

        @Override
        protected String getDescription() {
            return this.wrappedInstance.getDescription();
        }
    }
}

