/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.utility;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.PruneType;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.ResourceReaper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class JVMHookResourceReaper
extends ResourceReaper {
    JVMHookResourceReaper() {
    }

    @Override
    public void init() {
        this.setHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void performCleanup() {
        super.performCleanup();
        List list = DEATH_NOTE;
        synchronized (list) {
            DEATH_NOTE.forEach(filters -> this.prune(PruneType.CONTAINERS, (List<Map.Entry<String, String>>)filters));
            DEATH_NOTE.forEach(filters -> this.prune(PruneType.NETWORKS, (List<Map.Entry<String, String>>)filters));
            DEATH_NOTE.forEach(filters -> this.prune(PruneType.VOLUMES, (List<Map.Entry<String, String>>)filters));
            DEATH_NOTE.forEach(filters -> this.prune(PruneType.IMAGES, (List<Map.Entry<String, String>>)filters));
        }
    }

    private void prune(PruneType pruneType, List<Map.Entry<String, String>> filters) {
        String[] labels = (String[])filters.stream().filter(it -> "label".equals(it.getKey())).map(Map.Entry::getValue).toArray(String[]::new);
        switch (pruneType) {
            case CONTAINERS: {
                List containers = (List)this.dockerClient.listContainersCmd().withFilter("label", Arrays.asList(labels)).withShowAll(true).exec();
                containers.parallelStream().forEach(container -> this.dockerClient.removeContainerCmd(container.getId()).withForce(true).withRemoveVolumes(true).exec());
                break;
            }
            default: {
                this.dockerClient.pruneCmd(pruneType).withLabelFilter(labels).exec();
            }
        }
    }
}

