/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.utility;

interface Versioning {
    public static final AnyVersion ANY = new AnyVersion();

    public boolean isValid();

    public String getSeparator();

    public static class AnyVersion
    implements Versioning {
        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public String getSeparator() {
            return ":";
        }

        public String toString() {
            return "latest";
        }

        public boolean equals(Object obj) {
            return obj instanceof Versioning;
        }

        public int hashCode() {
            return super.hashCode();
        }

        private AnyVersion() {
        }
    }

    public static class Sha256Versioning
    implements Versioning {
        public static final String HASH_REGEX = "[0-9a-fA-F]{32,}";
        private final String hash;

        Sha256Versioning(String hash) {
            this.hash = hash;
        }

        @Override
        public boolean isValid() {
            return this.hash.matches(HASH_REGEX);
        }

        @Override
        public String getSeparator() {
            return "@";
        }

        public String toString() {
            return "sha256:" + this.hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sha256Versioning)) {
                return false;
            }
            Sha256Versioning other = (Sha256Versioning)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hash = this.hash;
            String other$hash = other.hash;
            return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sha256Versioning;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hash = this.hash;
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            return result;
        }
    }

    public static class TagVersioning
    implements Versioning {
        public static final String TAG_REGEX = "[\\w][\\w.\\-]{0,127}";
        static final TagVersioning LATEST = new TagVersioning("latest");
        private final String tag;

        TagVersioning(String tag) {
            this.tag = tag;
        }

        @Override
        public boolean isValid() {
            return this.tag.matches(TAG_REGEX);
        }

        @Override
        public String getSeparator() {
            return ":";
        }

        public String toString() {
            return this.tag;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TagVersioning)) {
                return false;
            }
            TagVersioning other = (TagVersioning)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tag = this.tag;
            String other$tag = other.tag;
            return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TagVersioning;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tag = this.tag;
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            return result;
        }
    }
}

