@file:Suppress("USELESS_CAST")

package dev.nesk.akkurate.accessors.kotlin

import dev.nesk.akkurate.validatables.Validatable
import dev.nesk.akkurate.validatables.validatableOf
import kotlin.Array
import kotlin.Boolean
import kotlin.BooleanArray
import kotlin.ByteArray
import kotlin.CharArray
import kotlin.CharSequence
import kotlin.DoubleArray
import kotlin.Enum
import kotlin.FloatArray
import kotlin.Int
import kotlin.IntArray
import kotlin.KotlinVersion
import kotlin.Lazy
import kotlin.LongArray
import kotlin.Pair
import kotlin.Result
import kotlin.ShortArray
import kotlin.String
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Triple
import kotlin.js.JsName
import kotlin.jvm.JvmName
import kotlin.reflect.KProperty1

/**
 * [Validatable] accessor of [Throwable.cause]
 */
public val Validatable<Throwable>.cause: Validatable<Throwable?>
  @JvmName(name = "validatableThrowableCause")
  @JsName(name = "validatableThrowableCause")
  get() = validatableOf(Throwable::cause as KProperty1)

/**
 * [Validatable] accessor of [Throwable.cause]
 */
public val Validatable<Throwable?>.cause: Validatable<Throwable?>
  @JvmName(name = "validatableNullableThrowableCause")
  @JsName(name = "validatableNullableThrowableCause")
  get() = validatableOf(Throwable::cause as KProperty1)

/**
 * [Validatable] accessor of [Throwable.message]
 */
public val Validatable<Throwable>.message: Validatable<String?>
  @JvmName(name = "validatableThrowableMessage")
  @JsName(name = "validatableThrowableMessage")
  get() = validatableOf(Throwable::message as KProperty1)

/**
 * [Validatable] accessor of [Throwable.message]
 */
public val Validatable<Throwable?>.message: Validatable<String?>
  @JvmName(name = "validatableNullableThrowableMessage")
  @JsName(name = "validatableNullableThrowableMessage")
  get() = validatableOf(Throwable::message as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.major]
 */
public val Validatable<KotlinVersion>.major: Validatable<Int>
  @JvmName(name = "validatableKotlinVersionMajor")
  @JsName(name = "validatableKotlinVersionMajor")
  get() = validatableOf(KotlinVersion::major as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.major]
 */
public val Validatable<KotlinVersion?>.major: Validatable<Int?>
  @JvmName(name = "validatableNullableKotlinVersionMajor")
  @JsName(name = "validatableNullableKotlinVersionMajor")
  get() = validatableOf(KotlinVersion::major as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.minor]
 */
public val Validatable<KotlinVersion>.minor: Validatable<Int>
  @JvmName(name = "validatableKotlinVersionMinor")
  @JsName(name = "validatableKotlinVersionMinor")
  get() = validatableOf(KotlinVersion::minor as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.minor]
 */
public val Validatable<KotlinVersion?>.minor: Validatable<Int?>
  @JvmName(name = "validatableNullableKotlinVersionMinor")
  @JsName(name = "validatableNullableKotlinVersionMinor")
  get() = validatableOf(KotlinVersion::minor as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.patch]
 */
public val Validatable<KotlinVersion>.patch: Validatable<Int>
  @JvmName(name = "validatableKotlinVersionPatch")
  @JsName(name = "validatableKotlinVersionPatch")
  get() = validatableOf(KotlinVersion::patch as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.patch]
 */
public val Validatable<KotlinVersion?>.patch: Validatable<Int?>
  @JvmName(name = "validatableNullableKotlinVersionPatch")
  @JsName(name = "validatableNullableKotlinVersionPatch")
  get() = validatableOf(KotlinVersion::patch as KProperty1)

/**
 * [Validatable] accessor of [Lazy.`value`]
 */
public val <T> Validatable<Lazy<T>>.`value`: Validatable<T>
  @JvmName(name = "validatableLazyValue")
  @JsName(name = "validatableLazyValue")
  get() = validatableOf(Lazy<T>::`value` as KProperty1)

/**
 * [Validatable] accessor of [Lazy.`value`]
 */
public val <T> Validatable<Lazy<T>?>.`value`: Validatable<T?>
  @JvmName(name = "validatableNullableLazyValue")
  @JsName(name = "validatableNullableLazyValue")
  get() = validatableOf(Lazy<T>::`value` as KProperty1)

/**
 * [Validatable] accessor of [Enum.name]
 */
public val <E : Enum<E>> Validatable<Enum<E>>.name: Validatable<String>
  @JvmName(name = "validatableEnumName")
  @JsName(name = "validatableEnumName")
  get() = validatableOf(Enum<E>::name as KProperty1)

/**
 * [Validatable] accessor of [Enum.name]
 */
public val <E : Enum<E>> Validatable<Enum<E>?>.name: Validatable<String?>
  @JvmName(name = "validatableNullableEnumName")
  @JsName(name = "validatableNullableEnumName")
  get() = validatableOf(Enum<E>::name as KProperty1)

/**
 * [Validatable] accessor of [Enum.ordinal]
 */
public val <E : Enum<E>> Validatable<Enum<E>>.ordinal: Validatable<Int>
  @JvmName(name = "validatableEnumOrdinal")
  @JsName(name = "validatableEnumOrdinal")
  get() = validatableOf(Enum<E>::ordinal as KProperty1)

/**
 * [Validatable] accessor of [Enum.ordinal]
 */
public val <E : Enum<E>> Validatable<Enum<E>?>.ordinal: Validatable<Int?>
  @JvmName(name = "validatableNullableEnumOrdinal")
  @JsName(name = "validatableNullableEnumOrdinal")
  get() = validatableOf(Enum<E>::ordinal as KProperty1)

/**
 * [Validatable] accessor of [Pair.first]
 */
public val <A, B> Validatable<Pair<A, B>>.first: Validatable<A>
  @JvmName(name = "validatablePairFirst")
  @JsName(name = "validatablePairFirst")
  get() = validatableOf(Pair<A, B>::first as KProperty1)

/**
 * [Validatable] accessor of [Pair.first]
 */
public val <A, B> Validatable<Pair<A, B>?>.first: Validatable<A?>
  @JvmName(name = "validatableNullablePairFirst")
  @JsName(name = "validatableNullablePairFirst")
  get() = validatableOf(Pair<A, B>::first as KProperty1)

/**
 * [Validatable] accessor of [Pair.second]
 */
public val <A, B> Validatable<Pair<A, B>>.second: Validatable<B>
  @JvmName(name = "validatablePairSecond")
  @JsName(name = "validatablePairSecond")
  get() = validatableOf(Pair<A, B>::second as KProperty1)

/**
 * [Validatable] accessor of [Pair.second]
 */
public val <A, B> Validatable<Pair<A, B>?>.second: Validatable<B?>
  @JvmName(name = "validatableNullablePairSecond")
  @JsName(name = "validatableNullablePairSecond")
  get() = validatableOf(Pair<A, B>::second as KProperty1)

/**
 * [Validatable] accessor of [Result.isFailure]
 */
public val <T> Validatable<Result<T>>.isFailure: Validatable<Boolean>
  @JvmName(name = "validatableResultIsFailure")
  @JsName(name = "validatableResultIsFailure")
  get() = validatableOf(Result<T>::isFailure as KProperty1)

/**
 * [Validatable] accessor of [Result.isFailure]
 */
public val <T> Validatable<Result<T>?>.isFailure: Validatable<Boolean?>
  @JvmName(name = "validatableNullableResultIsFailure")
  @JsName(name = "validatableNullableResultIsFailure")
  get() = validatableOf(Result<T>::isFailure as KProperty1)

/**
 * [Validatable] accessor of [Result.isSuccess]
 */
public val <T> Validatable<Result<T>>.isSuccess: Validatable<Boolean>
  @JvmName(name = "validatableResultIsSuccess")
  @JsName(name = "validatableResultIsSuccess")
  get() = validatableOf(Result<T>::isSuccess as KProperty1)

/**
 * [Validatable] accessor of [Result.isSuccess]
 */
public val <T> Validatable<Result<T>?>.isSuccess: Validatable<Boolean?>
  @JvmName(name = "validatableNullableResultIsSuccess")
  @JsName(name = "validatableNullableResultIsSuccess")
  get() = validatableOf(Result<T>::isSuccess as KProperty1)

/**
 * [Validatable] accessor of [Triple.first]
 */
public val <A, B, C> Validatable<Triple<A, B, C>>.first: Validatable<A>
  @JvmName(name = "validatableTripleFirst")
  @JsName(name = "validatableTripleFirst")
  get() = validatableOf(Triple<A, B, C>::first as KProperty1)

/**
 * [Validatable] accessor of [Triple.first]
 */
public val <A, B, C> Validatable<Triple<A, B, C>?>.first: Validatable<A?>
  @JvmName(name = "validatableNullableTripleFirst")
  @JsName(name = "validatableNullableTripleFirst")
  get() = validatableOf(Triple<A, B, C>::first as KProperty1)

/**
 * [Validatable] accessor of [Triple.second]
 */
public val <A, B, C> Validatable<Triple<A, B, C>>.second: Validatable<B>
  @JvmName(name = "validatableTripleSecond")
  @JsName(name = "validatableTripleSecond")
  get() = validatableOf(Triple<A, B, C>::second as KProperty1)

/**
 * [Validatable] accessor of [Triple.second]
 */
public val <A, B, C> Validatable<Triple<A, B, C>?>.second: Validatable<B?>
  @JvmName(name = "validatableNullableTripleSecond")
  @JsName(name = "validatableNullableTripleSecond")
  get() = validatableOf(Triple<A, B, C>::second as KProperty1)

/**
 * [Validatable] accessor of [Triple.third]
 */
public val <A, B, C> Validatable<Triple<A, B, C>>.third: Validatable<C>
  @JvmName(name = "validatableTripleThird")
  @JsName(name = "validatableTripleThird")
  get() = validatableOf(Triple<A, B, C>::third as KProperty1)

/**
 * [Validatable] accessor of [Triple.third]
 */
public val <A, B, C> Validatable<Triple<A, B, C>?>.third: Validatable<C?>
  @JvmName(name = "validatableNullableTripleThird")
  @JsName(name = "validatableNullableTripleThird")
  get() = validatableOf(Triple<A, B, C>::third as KProperty1)

/**
 * [Validatable] accessor of [Array.size]
 */
public val <T> Validatable<Array<T>>.size: Validatable<Int>
  @JvmName(name = "validatableArraySize")
  @JsName(name = "validatableArraySize")
  get() = validatableOf(Array<T>::size as KProperty1)

/**
 * [Validatable] accessor of [Array.size]
 */
public val <T> Validatable<Array<T>?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableArraySize")
  @JsName(name = "validatableNullableArraySize")
  get() = validatableOf(Array<T>::size as KProperty1)

/**
 * [Validatable] accessor of [BooleanArray.size]
 */
public val Validatable<BooleanArray>.size: Validatable<Int>
  @JvmName(name = "validatableBooleanArraySize")
  @JsName(name = "validatableBooleanArraySize")
  get() = validatableOf(BooleanArray::size as KProperty1)

/**
 * [Validatable] accessor of [BooleanArray.size]
 */
public val Validatable<BooleanArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableBooleanArraySize")
  @JsName(name = "validatableNullableBooleanArraySize")
  get() = validatableOf(BooleanArray::size as KProperty1)

/**
 * [Validatable] accessor of [ByteArray.size]
 */
public val Validatable<ByteArray>.size: Validatable<Int>
  @JvmName(name = "validatableByteArraySize")
  @JsName(name = "validatableByteArraySize")
  get() = validatableOf(ByteArray::size as KProperty1)

/**
 * [Validatable] accessor of [ByteArray.size]
 */
public val Validatable<ByteArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableByteArraySize")
  @JsName(name = "validatableNullableByteArraySize")
  get() = validatableOf(ByteArray::size as KProperty1)

/**
 * [Validatable] accessor of [CharArray.size]
 */
public val Validatable<CharArray>.size: Validatable<Int>
  @JvmName(name = "validatableCharArraySize")
  @JsName(name = "validatableCharArraySize")
  get() = validatableOf(CharArray::size as KProperty1)

/**
 * [Validatable] accessor of [CharArray.size]
 */
public val Validatable<CharArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableCharArraySize")
  @JsName(name = "validatableNullableCharArraySize")
  get() = validatableOf(CharArray::size as KProperty1)

/**
 * [Validatable] accessor of [CharSequence.length]
 */
public val Validatable<CharSequence>.length: Validatable<Int>
  @JvmName(name = "validatableCharSequenceLength")
  @JsName(name = "validatableCharSequenceLength")
  get() = validatableOf(CharSequence::length as KProperty1)

/**
 * [Validatable] accessor of [CharSequence.length]
 */
public val Validatable<CharSequence?>.length: Validatable<Int?>
  @JvmName(name = "validatableNullableCharSequenceLength")
  @JsName(name = "validatableNullableCharSequenceLength")
  get() = validatableOf(CharSequence::length as KProperty1)

/**
 * [Validatable] accessor of [DoubleArray.size]
 */
public val Validatable<DoubleArray>.size: Validatable<Int>
  @JvmName(name = "validatableDoubleArraySize")
  @JsName(name = "validatableDoubleArraySize")
  get() = validatableOf(DoubleArray::size as KProperty1)

/**
 * [Validatable] accessor of [DoubleArray.size]
 */
public val Validatable<DoubleArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableDoubleArraySize")
  @JsName(name = "validatableNullableDoubleArraySize")
  get() = validatableOf(DoubleArray::size as KProperty1)

/**
 * [Validatable] accessor of [FloatArray.size]
 */
public val Validatable<FloatArray>.size: Validatable<Int>
  @JvmName(name = "validatableFloatArraySize")
  @JsName(name = "validatableFloatArraySize")
  get() = validatableOf(FloatArray::size as KProperty1)

/**
 * [Validatable] accessor of [FloatArray.size]
 */
public val Validatable<FloatArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableFloatArraySize")
  @JsName(name = "validatableNullableFloatArraySize")
  get() = validatableOf(FloatArray::size as KProperty1)

/**
 * [Validatable] accessor of [IntArray.size]
 */
public val Validatable<IntArray>.size: Validatable<Int>
  @JvmName(name = "validatableIntArraySize")
  @JsName(name = "validatableIntArraySize")
  get() = validatableOf(IntArray::size as KProperty1)

/**
 * [Validatable] accessor of [IntArray.size]
 */
public val Validatable<IntArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableIntArraySize")
  @JsName(name = "validatableNullableIntArraySize")
  get() = validatableOf(IntArray::size as KProperty1)

/**
 * [Validatable] accessor of [LongArray.size]
 */
public val Validatable<LongArray>.size: Validatable<Int>
  @JvmName(name = "validatableLongArraySize")
  @JsName(name = "validatableLongArraySize")
  get() = validatableOf(LongArray::size as KProperty1)

/**
 * [Validatable] accessor of [LongArray.size]
 */
public val Validatable<LongArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableLongArraySize")
  @JsName(name = "validatableNullableLongArraySize")
  get() = validatableOf(LongArray::size as KProperty1)

/**
 * [Validatable] accessor of [ShortArray.size]
 */
public val Validatable<ShortArray>.size: Validatable<Int>
  @JvmName(name = "validatableShortArraySize")
  @JsName(name = "validatableShortArraySize")
  get() = validatableOf(ShortArray::size as KProperty1)

/**
 * [Validatable] accessor of [ShortArray.size]
 */
public val Validatable<ShortArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableShortArraySize")
  @JsName(name = "validatableNullableShortArraySize")
  get() = validatableOf(ShortArray::size as KProperty1)
