@file:Suppress("USELESS_CAST")

package dev.nesk.akkurate.accessors.kotlin

import dev.nesk.akkurate.validatables.Validatable
import dev.nesk.akkurate.validatables.validatableOf
import kotlin.Array
import kotlin.Boolean
import kotlin.BooleanArray
import kotlin.ByteArray
import kotlin.CharArray
import kotlin.CharSequence
import kotlin.DoubleArray
import kotlin.Enum
import kotlin.FloatArray
import kotlin.Int
import kotlin.IntArray
import kotlin.KotlinVersion
import kotlin.Lazy
import kotlin.LongArray
import kotlin.Pair
import kotlin.Result
import kotlin.ShortArray
import kotlin.String
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Triple
import kotlin.jvm.JvmName
import kotlin.reflect.KProperty1

/**
 * [Validatable] accessor of [Throwable.cause]
 */
public val Validatable<Throwable>.cause: Validatable<Throwable?>
  @JvmName(name = "validatableThrowableCause")
  get() = validatableOf(Throwable::cause as KProperty1)

/**
 * [Validatable] accessor of [Throwable.cause]
 */
public val Validatable<Throwable?>.cause: Validatable<Throwable?>
  @JvmName(name = "validatableNullableThrowableCause")
  get() = validatableOf(Throwable::cause as KProperty1)

/**
 * [Validatable] accessor of [Throwable.message]
 */
public val Validatable<Throwable>.message: Validatable<String?>
  @JvmName(name = "validatableThrowableMessage")
  get() = validatableOf(Throwable::message as KProperty1)

/**
 * [Validatable] accessor of [Throwable.message]
 */
public val Validatable<Throwable?>.message: Validatable<String?>
  @JvmName(name = "validatableNullableThrowableMessage")
  get() = validatableOf(Throwable::message as KProperty1)

/**
 * [Validatable] accessor of [Enum.name]
 */
public val <E : Enum<E>> Validatable<Enum<E>>.name: Validatable<String>
  @JvmName(name = "validatableEnumName")
  get() = validatableOf(Enum<E>::name as KProperty1)

/**
 * [Validatable] accessor of [Enum.name]
 */
public val <E : Enum<E>> Validatable<Enum<E>?>.name: Validatable<String?>
  @JvmName(name = "validatableNullableEnumName")
  get() = validatableOf(Enum<E>::name as KProperty1)

/**
 * [Validatable] accessor of [Enum.ordinal]
 */
public val <E : Enum<E>> Validatable<Enum<E>>.ordinal: Validatable<Int>
  @JvmName(name = "validatableEnumOrdinal")
  get() = validatableOf(Enum<E>::ordinal as KProperty1)

/**
 * [Validatable] accessor of [Enum.ordinal]
 */
public val <E : Enum<E>> Validatable<Enum<E>?>.ordinal: Validatable<Int?>
  @JvmName(name = "validatableNullableEnumOrdinal")
  get() = validatableOf(Enum<E>::ordinal as KProperty1)

/**
 * [Validatable] accessor of [Triple.first]
 */
public val <A, B, C> Validatable<Triple<A, B, C>>.first: Validatable<A>
  @JvmName(name = "validatableTripleFirst")
  get() = validatableOf(Triple<A, B, C>::first as KProperty1)

/**
 * [Validatable] accessor of [Triple.first]
 */
public val <A, B, C> Validatable<Triple<A, B, C>?>.first: Validatable<A?>
  @JvmName(name = "validatableNullableTripleFirst")
  get() = validatableOf(Triple<A, B, C>::first as KProperty1)

/**
 * [Validatable] accessor of [Triple.second]
 */
public val <A, B, C> Validatable<Triple<A, B, C>>.second: Validatable<B>
  @JvmName(name = "validatableTripleSecond")
  get() = validatableOf(Triple<A, B, C>::second as KProperty1)

/**
 * [Validatable] accessor of [Triple.second]
 */
public val <A, B, C> Validatable<Triple<A, B, C>?>.second: Validatable<B?>
  @JvmName(name = "validatableNullableTripleSecond")
  get() = validatableOf(Triple<A, B, C>::second as KProperty1)

/**
 * [Validatable] accessor of [Triple.third]
 */
public val <A, B, C> Validatable<Triple<A, B, C>>.third: Validatable<C>
  @JvmName(name = "validatableTripleThird")
  get() = validatableOf(Triple<A, B, C>::third as KProperty1)

/**
 * [Validatable] accessor of [Triple.third]
 */
public val <A, B, C> Validatable<Triple<A, B, C>?>.third: Validatable<C?>
  @JvmName(name = "validatableNullableTripleThird")
  get() = validatableOf(Triple<A, B, C>::third as KProperty1)

/**
 * [Validatable] accessor of [Lazy.`value`]
 */
public val <T> Validatable<Lazy<T>>.`value`: Validatable<T>
  @JvmName(name = "validatableLazyValue")
  get() = validatableOf(Lazy<T>::`value` as KProperty1)

/**
 * [Validatable] accessor of [Lazy.`value`]
 */
public val <T> Validatable<Lazy<T>?>.`value`: Validatable<T?>
  @JvmName(name = "validatableNullableLazyValue")
  get() = validatableOf(Lazy<T>::`value` as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.major]
 */
public val Validatable<KotlinVersion>.major: Validatable<Int>
  @JvmName(name = "validatableKotlinVersionMajor")
  get() = validatableOf(KotlinVersion::major as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.major]
 */
public val Validatable<KotlinVersion?>.major: Validatable<Int?>
  @JvmName(name = "validatableNullableKotlinVersionMajor")
  get() = validatableOf(KotlinVersion::major as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.minor]
 */
public val Validatable<KotlinVersion>.minor: Validatable<Int>
  @JvmName(name = "validatableKotlinVersionMinor")
  get() = validatableOf(KotlinVersion::minor as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.minor]
 */
public val Validatable<KotlinVersion?>.minor: Validatable<Int?>
  @JvmName(name = "validatableNullableKotlinVersionMinor")
  get() = validatableOf(KotlinVersion::minor as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.patch]
 */
public val Validatable<KotlinVersion>.patch: Validatable<Int>
  @JvmName(name = "validatableKotlinVersionPatch")
  get() = validatableOf(KotlinVersion::patch as KProperty1)

/**
 * [Validatable] accessor of [KotlinVersion.patch]
 */
public val Validatable<KotlinVersion?>.patch: Validatable<Int?>
  @JvmName(name = "validatableNullableKotlinVersionPatch")
  get() = validatableOf(KotlinVersion::patch as KProperty1)

/**
 * [Validatable] accessor of [Result.isFailure]
 */
public val <T> Validatable<Result<T>>.isFailure: Validatable<Boolean>
  @JvmName(name = "validatableResultIsFailure")
  get() = validatableOf(Result<T>::isFailure as KProperty1)

/**
 * [Validatable] accessor of [Result.isFailure]
 */
public val <T> Validatable<Result<T>?>.isFailure: Validatable<Boolean?>
  @JvmName(name = "validatableNullableResultIsFailure")
  get() = validatableOf(Result<T>::isFailure as KProperty1)

/**
 * [Validatable] accessor of [Result.isSuccess]
 */
public val <T> Validatable<Result<T>>.isSuccess: Validatable<Boolean>
  @JvmName(name = "validatableResultIsSuccess")
  get() = validatableOf(Result<T>::isSuccess as KProperty1)

/**
 * [Validatable] accessor of [Result.isSuccess]
 */
public val <T> Validatable<Result<T>?>.isSuccess: Validatable<Boolean?>
  @JvmName(name = "validatableNullableResultIsSuccess")
  get() = validatableOf(Result<T>::isSuccess as KProperty1)

/**
 * [Validatable] accessor of [Pair.first]
 */
public val <A, B> Validatable<Pair<A, B>>.first: Validatable<A>
  @JvmName(name = "validatablePairFirst")
  get() = validatableOf(Pair<A, B>::first as KProperty1)

/**
 * [Validatable] accessor of [Pair.first]
 */
public val <A, B> Validatable<Pair<A, B>?>.first: Validatable<A?>
  @JvmName(name = "validatableNullablePairFirst")
  get() = validatableOf(Pair<A, B>::first as KProperty1)

/**
 * [Validatable] accessor of [Pair.second]
 */
public val <A, B> Validatable<Pair<A, B>>.second: Validatable<B>
  @JvmName(name = "validatablePairSecond")
  get() = validatableOf(Pair<A, B>::second as KProperty1)

/**
 * [Validatable] accessor of [Pair.second]
 */
public val <A, B> Validatable<Pair<A, B>?>.second: Validatable<B?>
  @JvmName(name = "validatableNullablePairSecond")
  get() = validatableOf(Pair<A, B>::second as KProperty1)

/**
 * [Validatable] accessor of [Array.size]
 */
public val <T> Validatable<Array<T>>.size: Validatable<Int>
  @JvmName(name = "validatableArraySize")
  get() = validatableOf(Array<T>::size as KProperty1)

/**
 * [Validatable] accessor of [Array.size]
 */
public val <T> Validatable<Array<T>?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableArraySize")
  get() = validatableOf(Array<T>::size as KProperty1)

/**
 * [Validatable] accessor of [BooleanArray.size]
 */
public val Validatable<BooleanArray>.size: Validatable<Int>
  @JvmName(name = "validatableBooleanArraySize")
  get() = validatableOf(BooleanArray::size as KProperty1)

/**
 * [Validatable] accessor of [BooleanArray.size]
 */
public val Validatable<BooleanArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableBooleanArraySize")
  get() = validatableOf(BooleanArray::size as KProperty1)

/**
 * [Validatable] accessor of [ByteArray.size]
 */
public val Validatable<ByteArray>.size: Validatable<Int>
  @JvmName(name = "validatableByteArraySize")
  get() = validatableOf(ByteArray::size as KProperty1)

/**
 * [Validatable] accessor of [ByteArray.size]
 */
public val Validatable<ByteArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableByteArraySize")
  get() = validatableOf(ByteArray::size as KProperty1)

/**
 * [Validatable] accessor of [CharArray.size]
 */
public val Validatable<CharArray>.size: Validatable<Int>
  @JvmName(name = "validatableCharArraySize")
  get() = validatableOf(CharArray::size as KProperty1)

/**
 * [Validatable] accessor of [CharArray.size]
 */
public val Validatable<CharArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableCharArraySize")
  get() = validatableOf(CharArray::size as KProperty1)

/**
 * [Validatable] accessor of [CharSequence.length]
 */
public val Validatable<CharSequence>.length: Validatable<Int>
  @JvmName(name = "validatableCharSequenceLength")
  get() = validatableOf(CharSequence::length as KProperty1)

/**
 * [Validatable] accessor of [CharSequence.length]
 */
public val Validatable<CharSequence?>.length: Validatable<Int?>
  @JvmName(name = "validatableNullableCharSequenceLength")
  get() = validatableOf(CharSequence::length as KProperty1)

/**
 * [Validatable] accessor of [DoubleArray.size]
 */
public val Validatable<DoubleArray>.size: Validatable<Int>
  @JvmName(name = "validatableDoubleArraySize")
  get() = validatableOf(DoubleArray::size as KProperty1)

/**
 * [Validatable] accessor of [DoubleArray.size]
 */
public val Validatable<DoubleArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableDoubleArraySize")
  get() = validatableOf(DoubleArray::size as KProperty1)

/**
 * [Validatable] accessor of [FloatArray.size]
 */
public val Validatable<FloatArray>.size: Validatable<Int>
  @JvmName(name = "validatableFloatArraySize")
  get() = validatableOf(FloatArray::size as KProperty1)

/**
 * [Validatable] accessor of [FloatArray.size]
 */
public val Validatable<FloatArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableFloatArraySize")
  get() = validatableOf(FloatArray::size as KProperty1)

/**
 * [Validatable] accessor of [IntArray.size]
 */
public val Validatable<IntArray>.size: Validatable<Int>
  @JvmName(name = "validatableIntArraySize")
  get() = validatableOf(IntArray::size as KProperty1)

/**
 * [Validatable] accessor of [IntArray.size]
 */
public val Validatable<IntArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableIntArraySize")
  get() = validatableOf(IntArray::size as KProperty1)

/**
 * [Validatable] accessor of [LongArray.size]
 */
public val Validatable<LongArray>.size: Validatable<Int>
  @JvmName(name = "validatableLongArraySize")
  get() = validatableOf(LongArray::size as KProperty1)

/**
 * [Validatable] accessor of [LongArray.size]
 */
public val Validatable<LongArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableLongArraySize")
  get() = validatableOf(LongArray::size as KProperty1)

/**
 * [Validatable] accessor of [ShortArray.size]
 */
public val Validatable<ShortArray>.size: Validatable<Int>
  @JvmName(name = "validatableShortArraySize")
  get() = validatableOf(ShortArray::size as KProperty1)

/**
 * [Validatable] accessor of [ShortArray.size]
 */
public val Validatable<ShortArray?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableShortArraySize")
  get() = validatableOf(ShortArray::size as KProperty1)
