@file:Suppress("USELESS_CAST")

package dev.nesk.akkurate.accessors.kotlin.collections

import dev.nesk.akkurate.validatables.Validatable
import dev.nesk.akkurate.validatables.validatableOf
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.Collection
import kotlin.collections.IndexedValue
import kotlin.collections.Map
import kotlin.collections.Set
import kotlin.jvm.JvmName
import kotlin.reflect.KProperty1

/**
 * [Validatable] accessor of [Collection.size]
 */
public val <E> Validatable<Collection<E>>.size: Validatable<Int>
  @JvmName(name = "validatableCollectionSize")
  get() = validatableOf(Collection<E>::size as KProperty1)

/**
 * [Validatable] accessor of [Collection.size]
 */
public val <E> Validatable<Collection<E>?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableCollectionSize")
  get() = validatableOf(Collection<E>::size as KProperty1)

/**
 * [Validatable] accessor of [Map.entries]
 */
public val <K, V> Validatable<Map<K, V>>.entries: Validatable<Set<Map.Entry<K, V>>>
  @JvmName(name = "validatableMapEntries")
  get() = validatableOf(Map<K, V>::entries as KProperty1)

/**
 * [Validatable] accessor of [Map.entries]
 */
public val <K, V> Validatable<Map<K, V>?>.entries: Validatable<Set<Map.Entry<K, V>>?>
  @JvmName(name = "validatableNullableMapEntries")
  get() = validatableOf(Map<K, V>::entries as KProperty1)

/**
 * [Validatable] accessor of [Map.keys]
 */
public val <K, V> Validatable<Map<K, V>>.keys: Validatable<Set<K>>
  @JvmName(name = "validatableMapKeys")
  get() = validatableOf(Map<K, V>::keys as KProperty1)

/**
 * [Validatable] accessor of [Map.keys]
 */
public val <K, V> Validatable<Map<K, V>?>.keys: Validatable<Set<K>?>
  @JvmName(name = "validatableNullableMapKeys")
  get() = validatableOf(Map<K, V>::keys as KProperty1)

/**
 * [Validatable] accessor of [Map.size]
 */
public val <K, V> Validatable<Map<K, V>>.size: Validatable<Int>
  @JvmName(name = "validatableMapSize")
  get() = validatableOf(Map<K, V>::size as KProperty1)

/**
 * [Validatable] accessor of [Map.size]
 */
public val <K, V> Validatable<Map<K, V>?>.size: Validatable<Int?>
  @JvmName(name = "validatableNullableMapSize")
  get() = validatableOf(Map<K, V>::size as KProperty1)

/**
 * [Validatable] accessor of [Map.values]
 */
public val <K, V> Validatable<Map<K, V>>.values: Validatable<Collection<V>>
  @JvmName(name = "validatableMapValues")
  get() = validatableOf(Map<K, V>::values as KProperty1)

/**
 * [Validatable] accessor of [Map.values]
 */
public val <K, V> Validatable<Map<K, V>?>.values: Validatable<Collection<V>?>
  @JvmName(name = "validatableNullableMapValues")
  get() = validatableOf(Map<K, V>::values as KProperty1)

/**
 * [Validatable] accessor of [IndexedValue.index]
 */
public val <T> Validatable<IndexedValue<T>>.index: Validatable<Int>
  @JvmName(name = "validatableIndexedValueIndex")
  get() = validatableOf(IndexedValue<T>::index as KProperty1)

/**
 * [Validatable] accessor of [IndexedValue.index]
 */
public val <T> Validatable<IndexedValue<T>?>.index: Validatable<Int?>
  @JvmName(name = "validatableNullableIndexedValueIndex")
  get() = validatableOf(IndexedValue<T>::index as KProperty1)

/**
 * [Validatable] accessor of [IndexedValue.`value`]
 */
public val <T> Validatable<IndexedValue<T>>.`value`: Validatable<T>
  @JvmName(name = "validatableIndexedValueValue")
  get() = validatableOf(IndexedValue<T>::`value` as KProperty1)

/**
 * [Validatable] accessor of [IndexedValue.`value`]
 */
public val <T> Validatable<IndexedValue<T>?>.`value`: Validatable<T?>
  @JvmName(name = "validatableNullableIndexedValueValue")
  get() = validatableOf(IndexedValue<T>::`value` as KProperty1)

/**
 * [Validatable] accessor of [Map.Entry.key]
 */
public val <K, V> Validatable<Map.Entry<K, V>>.key: Validatable<K>
  @JvmName(name = "validatableMapEntryKey")
  get() = validatableOf(Map.Entry<K, V>::key as KProperty1)

/**
 * [Validatable] accessor of [Map.Entry.key]
 */
public val <K, V> Validatable<Map.Entry<K, V>?>.key: Validatable<K?>
  @JvmName(name = "validatableNullableMapEntryKey")
  get() = validatableOf(Map.Entry<K, V>::key as KProperty1)

/**
 * [Validatable] accessor of [Map.Entry.`value`]
 */
public val <K, V> Validatable<Map.Entry<K, V>>.`value`: Validatable<V>
  @JvmName(name = "validatableMapEntryValue")
  get() = validatableOf(Map.Entry<K, V>::`value` as KProperty1)

/**
 * [Validatable] accessor of [Map.Entry.`value`]
 */
public val <K, V> Validatable<Map.Entry<K, V>?>.`value`: Validatable<V?>
  @JvmName(name = "validatableNullableMapEntryValue")
  get() = validatableOf(Map.Entry<K, V>::`value` as KProperty1)
