/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5;

import dev.pumpo5.core.Lookup;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import java.util.Random;
import org.openqa.selenium.Capabilities;
import org.slf4j.helpers.MessageFormatter;

public class Utils {
    static Random random = new Random();
    private static final String CONSONANTS = "bcdfghjklmnrstv";
    private static final String VOWELS = "aeiou";
    public static final String LOOKUP_DEFAULT = "pn5:lookup:default";
    private static final DateTimeFormatter timeFormatter = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").toFormatter();

    public static String mFormat(String pattern, Object ... args) {
        return MessageFormatter.arrayFormat((String)pattern, (Object[])args).getMessage();
    }

    public static String generatePronounceableString(int length) {
        StringBuilder result = new StringBuilder();
        int consonantsCount = CONSONANTS.length();
        int vowelsCount = VOWELS.length();
        for (int i = 0; i < length; ++i) {
            if (i % 2 == 0) {
                result.append(CONSONANTS.charAt(random.nextInt(consonantsCount)));
                continue;
            }
            result.append(VOWELS.charAt(random.nextInt(vowelsCount)));
        }
        return result.toString();
    }

    public static String currentTimeAsString(ZoneId zoneId) {
        return timeFormatter.withZone(zoneId).format(Instant.now());
    }

    public static ZoneId zoneIdFrom(String city) {
        return ZoneId.getAvailableZoneIds().stream().filter(z -> z.toLowerCase(Locale.ROOT).contains(city)).findFirst().map(ZoneId::of).orElse(ZoneId.of("Europe/Prague"));
    }

    public static Lookup getDefaultLookupValue(Capabilities capabilities, Lookup type) {
        String defaultLookup;
        if (type == Lookup.DEFAULT && (defaultLookup = (String)capabilities.getCapability(LOOKUP_DEFAULT)) != null && (type = Lookup.get(defaultLookup)) == null) {
            throw new IllegalArgumentException(String.format("Invalid Lookup value '%s'", defaultLookup));
        }
        return type;
    }

    private Utils() {
    }
}

