/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.config;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;

public class Config {
    private com.typesafe.config.Config config;

    public Config() {
        this.config = ConfigFactory.load();
    }

    public Config(String filename) {
        this.config = ConfigFactory.load((String)filename);
    }

    public Config(Config from, String prefix) {
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        try {
            this.config = from.config.getConfig(prefix);
        }
        catch (ConfigException.Missing missing) {
            this.config = ConfigFactory.empty();
        }
    }

    public boolean getBoolean(String key) {
        return this.config.hasPath(key) && this.config.getBoolean(key);
    }

    public String get(Object key) {
        String path = String.valueOf(key);
        try {
            if (this.config.hasPath(path)) {
                return this.config.getString(path);
            }
            return null;
        }
        catch (ConfigException.BadPath badPath) {
            return null;
        }
    }

    public String getOrDefault(Object key, String defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean getOrDefault(Object key, boolean defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.config.entrySet().size();
    }

    public boolean containsKey(String key) {
        return this.config.hasPath(key);
    }
}

