/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.config;

import dev.pumpo5.config.Config;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class ConfigHelper {
    public static final String KEY = "CONFIG";

    private ConfigHelper() {
    }

    public static Config getConfig(ExtensionContext context) {
        return (Config)context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).getOrComputeIfAbsent((Object)KEY, k -> new Config("config.conf"), Config.class);
    }

    public static Boolean getBoolean(ExtensionContext context, String key) {
        Config config = ConfigHelper.getConfig(context);
        return config.containsKey(key) && config.getBoolean(key);
    }

    public static String getOrThrow(Config config, String key) {
        if (config.containsKey(key)) {
            return config.get(key);
        }
        throw new IllegalArgumentException(String.format("Cannot find required commons.config parameter: %s", key));
    }
}

