/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum Lookup {
    DEFAULT("default"),
    ID("id"),
    XPATH("xpath"),
    CSS(" css"),
    NAME("name"),
    TEXT("text"),
    CLASS_NAME("className"),
    DESCRIPTION("description"),
    ACCESSIBILITY_ID("accessibilityId"),
    AUTOMATOR_COMMAND("automatorCommand"),
    METHOD("method");

    private final String name;
    private static final Map<String, Lookup> ENUM_MAP;

    private Lookup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Lookup get(String name) {
        return ENUM_MAP.get(name.toLowerCase());
    }

    static {
        ConcurrentHashMap<String, Lookup> map = new ConcurrentHashMap<String, Lookup>();
        for (Lookup instance : Lookup.values()) {
            map.put(instance.getName().toLowerCase(), instance);
        }
        ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

