/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.junit5;

import dev.pumpo5.config.Config;
import dev.pumpo5.config.ConfigHelper;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.PumpoEvents;
import dev.pumpo5.core.Store;
import dev.pumpo5.core.junit5.StoreWrapper;
import dev.pumpo5.reporting.Reporter;
import dev.pumpo5.reporting.junit.JUnitReporterStorageSupport;
import org.junit.jupiter.api.extension.ExtensionContext;

public class Core
implements CoreAccessor {
    private final Store localStore;
    private final Store globalStore;
    private final Config config;
    private final Reporter reporter;
    private final Logger logger;

    public static Core get(ExtensionContext extensionContext) {
        return new Core(extensionContext);
    }

    private Core(ExtensionContext extensionContext) {
        this.localStore = new StoreWrapper(extensionContext.getStore(ExtensionContext.Namespace.GLOBAL));
        this.globalStore = new StoreWrapper(extensionContext.getStore(ExtensionContext.Namespace.GLOBAL));
        this.config = ConfigHelper.getConfig(extensionContext);
        this.reporter = JUnitReporterStorageSupport.findReporterIn(extensionContext);
        this.logger = new PumpoEvents();
    }

    @Override
    public Store getLocalStore() {
        return this.localStore;
    }

    @Override
    public Store getGlobalStore() {
        return this.globalStore;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Reporter getReporter() {
        return this.reporter;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

