/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.pumpo5.PumpoException;
import dev.pumpo5.Utils;
import dev.pumpo5.config.Config;
import dev.pumpo5.core.webdriver.Capability;
import dev.pumpo5.core.webdriver.WebDriverClientExtension;
import dev.pumpo5.core.webdriver.WebDriverUrl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionUtils.class);
    public static final String CHECK_CAPABILITIES_AGAIN = "'hasValue' is set but 'whenParameter' is empty for capability '%s'. Please, check your capabilities again.";
    static ObjectMapper MAPPER = new ObjectMapper();

    private ExtensionUtils() {
    }

    public static Collector<Capability, ?, Map<String, Object>> toCapabilitiesMap(Config config) {
        return Collector.of(HashMap::new, (m, c) -> m.put(c.key(), ExtensionUtils.convertCapabilityValue(c, config)), (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        }, new Collector.Characteristics[0]);
    }

    public static <T> T convertCapabilityValue(Capability capability, Config config) {
        String value = capability.value();
        switch (capability.type()) {
            case STRING: {
                return (T)value;
            }
            case INTEGER: {
                return (T)Integer.valueOf(value);
            }
            case FLOAT: {
                return (T)Float.valueOf(value);
            }
            case BOOLEAN: {
                return (T)Boolean.valueOf(value);
            }
            case STRING_PROPERTY: {
                String capValue = config.get(value);
                ExtensionUtils.analyzeValueFromConfig(capValue, capability);
                return (T)capValue;
            }
            case INTEGER_PROPERTY: {
                String capValue = config.get(value);
                ExtensionUtils.analyzeValueFromConfig(capValue, capability);
                return (T)Integer.valueOf(capValue);
            }
            case FLOAT_PROPERTY: {
                String capValue = config.get(value);
                ExtensionUtils.analyzeValueFromConfig(capValue, capability);
                return (T)Float.valueOf(capValue);
            }
            case BOOLEAN_PROPERTY: {
                String capValue = config.get(value);
                ExtensionUtils.analyzeValueFromConfig(capValue, capability);
                return (T)Boolean.valueOf(capValue);
            }
            case OBJECT: {
                return ExtensionUtils.resolveObjectCapability(value, capability);
            }
            case OBJECT_PROPERTY: {
                String capValue = config.get(value);
                ExtensionUtils.analyzeValueFromConfig(capValue, capability);
                return ExtensionUtils.resolveObjectCapability(capValue, capability);
            }
        }
        throw new PumpoException(Utils.mFormat("Unknown property type {}", new Object[]{capability.type()}));
    }

    private static void analyzeValueFromConfig(String capValue, Capability capability) {
        if (capValue == null) {
            LOG.warn("Value for capability {} with property {} is null from the current configuration. Please, make sure your configuration is correct.", (Object)capability.key(), (Object)capability.value());
        }
        if (StringUtils.isWhitespace((CharSequence)capValue)) {
            LOG.warn("Value for capability {} with property {} is empty from the current configuration. Please, make sure your configuration is correct.", (Object)capability.key(), (Object)capability.value());
        }
    }

    private static <T> T resolveObjectCapability(String capability, Capability capability1) {
        try {
            return (T)MAPPER.readValue(capability, Object.class);
        }
        catch (JsonProcessingException e) {
            throw new PumpoException(Utils.mFormat("Could not parse the provided capability {} as Object, it must be a valid JSON with double quotes delimiting both keys and string values", capability1.key()), e);
        }
    }

    public static <T> Stream<T> defaultIfEmpty(Stream<T> stream, Supplier<Stream<T>> supplier) {
        Iterator iterator = stream.iterator();
        if (iterator.hasNext()) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
        }
        return supplier.get();
    }

    public static <DEVICE extends Annotation> Stream<Triple<String, String, Map<String, Object>>> getDeviceDescriptors(Parameter parameter, Class<DEVICE> deviceClass, Function<DEVICE, String> getDescription, Function<DEVICE, Capability[]> getCapabilities, Function<DEVICE, Boolean> doesInherit, Config config) {
        String driverUrl = ExtensionUtils.getDriverUrl(parameter, config);
        return Arrays.stream(parameter.getAnnotationsByType(deviceClass)).map(d -> {
            Map<String, Object> capabilities = Stream.of(Arrays.stream((Capability[])parameter.getType().getAnnotationsByType(Capability.class)).filter(c -> (Boolean)doesInherit.apply(d)), Arrays.stream((Capability[])parameter.getAnnotationsByType(Capability.class)).filter(c -> (Boolean)doesInherit.apply(d)), Arrays.stream((Capability[])getCapabilities.apply(d))).flatMap(c -> c).collect(ExtensionUtils.toCapabilitiesMap(config));
            return Triple.of((Object)((String)getDescription.apply(d)), (Object)driverUrl, capabilities);
        });
    }

    public static String getDriverUrl(Parameter parameter, Config config) {
        WebDriverUrl webDriverUrlAnnotation = parameter.getAnnotation(WebDriverUrl.class);
        if (webDriverUrlAnnotation == null) {
            webDriverUrlAnnotation = parameter.getType().getAnnotation(WebDriverUrl.class);
        }
        if (webDriverUrlAnnotation != null) {
            String url = config.get(webDriverUrlAnnotation.value());
            if (url != null) {
                return url;
            }
            return webDriverUrlAnnotation.value();
        }
        return ExtensionUtils.getDriverUrl(parameter.getType(), config);
    }

    public static String getDriverUrl(Class<?> type, Config config) {
        WebDriverUrl webDriverUrlAnnotation = type.getAnnotation(WebDriverUrl.class);
        if (webDriverUrlAnnotation != null) {
            String url = config.get(webDriverUrlAnnotation.value());
            if (url != null) {
                return url;
            }
            return webDriverUrlAnnotation.value();
        }
        return ExtensionUtils.getDriverUrl(config);
    }

    public static String getDriverUrl(Config config) {
        if (!config.containsKey("webdriver.url")) {
            throw new IllegalArgumentException("Cannot find the webdriver.url in configuration. Don't know where to connect...");
        }
        return config.get("webdriver.url");
    }

    public static Capability[] analyzeCapabilities(Capability[] capabilities, Config config) {
        ArrayList<Capability> listCapabilities = new ArrayList<Capability>();
        for (Capability capability : capabilities) {
            if (capability.whenParameter().isEmpty()) {
                if (capability.hasValue().isEmpty()) {
                    listCapabilities.add(capability);
                    continue;
                }
                throw new PumpoException(String.format(CHECK_CAPABILITIES_AGAIN, capability.key()));
            }
            String whenParameter = capability.whenParameter();
            if (capability.hasValue().isEmpty()) {
                if (!Arrays.stream(capabilities).anyMatch(c -> c.key().equals(whenParameter))) continue;
                listCapabilities.add(capability);
                continue;
            }
            String hasValue = capability.hasValue();
            Capability targetCapability = Arrays.stream(capabilities).filter(c -> c.key().equals(whenParameter)).findFirst().orElse(null);
            if (targetCapability != null && hasValue.equals(ExtensionUtils.convertCapabilityValue(targetCapability, config))) {
                listCapabilities.add(capability);
                continue;
            }
            LOG.debug("Excluding capability because conditions don't match: {}", (Object)capability);
        }
        return listCapabilities.toArray(new Capability[0]);
    }

    public static Map<String, Object> parseCapabilities(Capability[] capabilitiesList, Config config) {
        HashMap<String, Object> capabilities = new HashMap<String, Object>();
        Stream.of(capabilitiesList).forEach(capability -> {
            String targetMapKey = capability.key().equals("enableVNC") || capability.key().equals("name") || capability.key().equals("sessionTimeout") ? "selenoid:options" : capability.group();
            WebDriverClientExtension.ensureCapabilitiesGroup(capabilities, targetMapKey).put(capability.key(), ExtensionUtils.convertCapabilityValue(capability, config));
        });
        return capabilities;
    }

    public static void computeDefaults(Map<String, Object> capabilities) {
        WebDriverClientExtension.ensureCapabilitiesGroup(capabilities, "selenoid:options").putIfAbsent("sessionTimeout", "70s");
    }
}

