/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.util;

import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.logging.LoggingUtils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class ResolutionUtils {
    public static String resolvePathOrString(Logger logger, Object context, String pathOrString) {
        InputStream inputStream = context.getClass().getClassLoader().getResourceAsStream(pathOrString);
        if (inputStream != null) {
            try {
                return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.log(LogLevel.INFO, "File {} not found > assuming it is a string", LoggingUtils.ellipsis(pathOrString, 40));
        return pathOrString;
    }
}

