/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.util;

import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.PumpoEvents;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.ResponseProcessingException;
import jakarta.ws.rs.core.Response;
import java.net.ConnectException;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;

public class RetryUtils {
    private static Logger logger = new PumpoEvents();
    public static final List<Class<? extends Exception>> NETWORK_EXCEPTIONS = List.of(ResponseProcessingException.class, ProcessingException.class, ConnectException.class);

    public static <T> T retry(int maxRetries, Duration retryInterval, Supplier<T> action, List<Class<? extends Exception>> retryOn) {
        if (maxRetries < 1) {
            throw new IllegalArgumentException("maxRetries has to be at least 1");
        }
        int i = 0;
        while (true) {
            try {
                return action.get();
            }
            catch (Exception e) {
                if (!RetryUtils.isInstanceOfAny(e, retryOn)) {
                    throw e;
                }
                logger.log(LogLevel.WARN, "Exception occurred, retrying. Exception: {}", e.getMessage());
                if (++i == maxRetries) {
                    throw e;
                }
                try {
                    Thread.sleep(retryInterval.toMillis());
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            break;
        }
    }

    public static Response invokeWithRetry(int maxRetries, Duration retryInterval, Invocation invocation) {
        return RetryUtils.retry(maxRetries, retryInterval, () -> ((Invocation)invocation).invoke(), NETWORK_EXCEPTIONS);
    }

    private static boolean isInstanceOfAny(Exception e, List<Class<? extends Exception>> classes) {
        for (Class<? extends Exception> clazz : classes) {
            if (!clazz.isInstance(e)) continue;
            return true;
        }
        return false;
    }
}

