/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.util.error;

import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.util.error.ErrorType;
import dev.pumpo5.core.util.error.analysers.ErrorAnalyser;
import dev.pumpo5.core.util.error.analysers.impl.KafkaTimeoutExceptionAnalyser;
import dev.pumpo5.core.util.error.analysers.impl.SQLServerExceptionAnalyser;
import java.util.ArrayList;
import java.util.List;

public class ErrorAnalysisUtils {
    public static final List<ErrorAnalyser> errorAnalysers = new ArrayList<ErrorAnalyser>();

    public static ErrorType analyseAndLogWebDriverError(Throwable e, Logger logger) {
        return errorAnalysers.stream().map(errorAnalyser -> errorAnalyser.analyse(e)).filter(errorType -> !errorType.equals((Object)ErrorType.DEFAULT_WEBDRIVER_ERROR)).findFirst().map(errorType -> {
            logger.log(LogLevel.ERROR, errorType.getLabel(), new Object[0]);
            return errorType;
        }).orElse(ErrorType.DEFAULT_WEBDRIVER_ERROR);
    }

    static {
        errorAnalysers.add(new SQLServerExceptionAnalyser());
        errorAnalysers.add(new KafkaTimeoutExceptionAnalyser());
    }
}

